<?php
	/**
	 * @package    mod_formea_form
	 *
	 * @author     Feseur Sdn Bhd
	 * @copyright  Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license    GNU General Public License version 2 or later; see LICENSE.txt
	 * @link       https://feseur.com
	 * @version    1.0.2
	 */

	use Joomla\CMS\Factory;
	use Joomla\CMS\Helper\ModuleHelper;
	use Joomla\CMS\Log\Log;
	use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;
	use Joomla\Registry\Registry;

	defined('_JEXEC') or die;

	/** @var Registry $params */
	try
	{
		$form_id = (int) $params->get('form_id', 0);
		if ($form_id < 1)
		{
			throw new Exception('No Form Selected');
		}

		$renderForm = FormeaGeneralHelper::renderForm($form_id, true);
		$app        = Factory::getApplication();

		if (!$renderForm->success)
		{
			if (isset($renderForm->msg[0]))
			{
				$app->enqueueMessage($renderForm->msg[0]->text, $renderForm->msg[0]->type);
			}
		}
		else
		{
			require ModuleHelper::getLayoutPath('mod_formea_form', $params->get('layout', 'default'));
		}
	}
	catch (Exception $e)
	{
		Log::add($e->getMessage(), Log::ERROR, 'com_formea');
	}


