<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	defined('_JEXEC') or die;


	use Joomla\CMS\Categories\CategoryFactoryInterface;
	use Joomla\CMS\Component\Router\RouterFactoryInterface;
	use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
	use Joomla\CMS\Extension\ComponentInterface;
	use Joomla\CMS\Extension\Service\Provider\CategoryFactory;
	use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
	use Joomla\CMS\Extension\Service\Provider\MVCFactory;
	use Joomla\CMS\Extension\Service\Provider\RouterFactory;
	use Joomla\CMS\HTML\Registry;
	use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
	use Joomla\Component\Formea\Administrator\Extension\FormeaComponent;
	use Joomla\DI\Container;
	use Joomla\DI\ServiceProviderInterface;

	/**
	 * The formeas service provider.
	 * https://github.com/joomla/joomla-cms/pull/20217
	 *
	 * @since  1.0.0
	 */
	return new class implements ServiceProviderInterface {
		/**
		 * Registers the service provider with a DI container.
		 *
		 * @param   Container  $container  The DI container.
		 *
		 * @return  void
		 *
		 * @since   1.0.0
		 */
		public function register(Container $container)
		{
			$container->registerServiceProvider(new CategoryFactory('\\Joomla\\Component\\Formea'));
			$container->registerServiceProvider(new MVCFactory('\\Joomla\\Component\\Formea'));
			$container->registerServiceProvider(new ComponentDispatcherFactory('\\Joomla\\Component\\Formea'));
			$container->registerServiceProvider(new RouterFactory('\\Joomla\\Component\\Formea'));

			$container->set(
				ComponentInterface::class,
				function (Container $container) {
					$component = new FormeaComponent($container->get(ComponentDispatcherFactoryInterface::class));

					$component->setRegistry($container->get(Registry::class));
					$component->setMVCFactory($container->get(MVCFactoryInterface::class));
					$component->setCategoryFactory($container->get(CategoryFactoryInterface::class));
					$component->setRouterFactory($container->get(RouterFactoryInterface::class));

					return $component;
				}
			);
		}
	};
