CREATE TABLE IF NOT EXISTS `#__formea_cores` (
`id` int NOT NULL AUTO_INCREMENT,
`name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`creation_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`copyright` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`license` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`state` tinyint NOT NULL DEFAULT '0',
`has_view` tinyint NOT NULL DEFAULT '0',
`extension_type` tinyint NOT NULL DEFAULT '0',
`checked_out` int DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`modified_date` datetime DEFAULT NULL,
`modified_by` int NOT NULL DEFAULT '0',
`created_by` int NOT NULL DEFAULT '0',
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_elements` (
`id` int NOT NULL AUTO_INCREMENT,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
`type` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
`state` tinyint NOT NULL DEFAULT '1',
`params` mediumtext COLLATE utf8mb4_general_ci,
`checked_out` int DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`modified_date` datetime DEFAULT NULL,
`modified_by` int NOT NULL DEFAULT '0',
`created_by` int NOT NULL DEFAULT '0',
`access_level` int NOT NULL,
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `idx_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_element_attributes` (
`id` int NOT NULL AUTO_INCREMENT,
`element_id` int NOT NULL,
`class` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`size` int DEFAULT NULL,
`max_size` int DEFAULT NULL,
`additional_attr` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `idx_element` (`element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_element_details` (
`id` int NOT NULL AUTO_INCREMENT,
`element_id` int NOT NULL,
`caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`placeholder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `idx_element` (`element_id`),
KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_element_validations` (
`id` int NOT NULL AUTO_INCREMENT,
`element_id` int NOT NULL,
`validation_type` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
`params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`invalid_messages` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`),
KEY `idx_element` (`element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_element_values` (
`id` int NOT NULL AUTO_INCREMENT,
`element_id` int NOT NULL,
`defval` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
`option_lists` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
`language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `idx_element` (`element_id`),
KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_eltypes` (
`id` int NOT NULL AUTO_INCREMENT,
`name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`creation_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`copyright` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`license` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`value_type` tinyint NOT NULL DEFAULT '0',
`description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`state` tinyint NOT NULL DEFAULT '0',
`checked_out` int DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`modified_date` datetime DEFAULT NULL,
`modified_by` int NOT NULL DEFAULT '0',
`created_by` int NOT NULL DEFAULT '0',
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_extension_styles` (
`id` int NOT NULL AUTO_INCREMENT,
`extension_id` int NOT NULL COMMENT 'core_id|theme_id',
`extension_type` tinyint NOT NULL,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_formdetails` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`form_heading` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`metakey` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`metadesc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `idx_form` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__formea_formemailcontent` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`email_id` int NOT NULL,
`from_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`replyto_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`email_content` text COLLATE utf8mb4_general_ci,
`language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `idx_form` (`form_id`),
KEY `idx_email` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_formemails` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`target_type` int NOT NULL COMMENT '0-admin,1-user,2-others',
`from_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`to_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`cc_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`bcc_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`replyto_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `idx_form` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_forms` (
`id` int NOT NULL AUTO_INCREMENT,
`title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
`alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`state` tinyint NOT NULL DEFAULT '0',
`limit_submission` int NOT NULL DEFAULT '0',
`allow_submission` TINYINT NOT NULL DEFAULT '0',
`inline_css` text COLLATE utf8mb4_unicode_ci,
`additional_css` text COLLATE utf8mb4_unicode_ci,
`inline_js` text COLLATE utf8mb4_unicode_ci,
`additional_js` text COLLATE utf8mb4_unicode_ci,
`admin_column` text COLLATE utf8mb4_unicode_ci,
`form_type` tinyint NOT NULL DEFAULT '0',
`access_level` int NOT NULL,
`params` mediumtext COLLATE utf8mb4_unicode_ci,
`checked_out` int UNSIGNED DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`created_by` int UNSIGNED NOT NULL DEFAULT '0',
`modified_date` datetime DEFAULT NULL,
`modified_by` int UNSIGNED NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `idx_state` (`state`),
KEY `access_level` (`access_level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__formea_formsubmissions` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`submission_msg` text COLLATE utf8mb4_general_ci,
`global_error_msg` text COLLATE utf8mb4_general_ci,
`limit_reach_msg` text COLLATE utf8mb4_general_ci,
`language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `idx_form` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_formthemes` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`theme_id` int NOT NULL DEFAULT '0',
`style_id` int NOT NULL DEFAULT '0',
`load_css` int NOT NULL,
`load_js` int NOT NULL,
PRIMARY KEY (`id`),
KEY `idx_form` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_form_columns` (
`id` int NOT NULL AUTO_INCREMENT,
`column_type` tinyint NOT NULL DEFAULT '0',
`form_id` int NOT NULL,
`page_id` int NOT NULL DEFAULT '0',
`group_id` int NOT NULL DEFAULT '0',
`column` tinyint NOT NULL,
`settings` text COLLATE utf8mb4_general_ci,
`class` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`styleSheet` text COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`),
KEY `id` (`id`,`column_type`,`form_id`,`page_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_form_cores` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`enabled` tinyint NOT NULL DEFAULT '0',
`corename` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_form_elements` (
`id` int NOT NULL AUTO_INCREMENT,
`target_type` tinyint NOT NULL DEFAULT '0',
`form_id` int NOT NULL,
`page_id` int NOT NULL DEFAULT '0',
`group_id` int NOT NULL DEFAULT '0',
`element_id` int NOT NULL,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`elementTypeTitle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`labelSettings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`styleSheet` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`),
KEY `form_id` (`form_id`,`page_id`,`element_id`),
KEY `target_type` (`target_type`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


CREATE TABLE IF NOT EXISTS `#__formea_form_fieldsets` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`title` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`subtitle` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`icon` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`layout` text COLLATE utf8mb4_general_ci,
`styleSheet` text COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE IF NOT EXISTS `#__formea_form_groups` (
`id` int NOT NULL AUTO_INCREMENT,
`group_type` tinyint NOT NULL DEFAULT '0',
`group_id` int NOT NULL,
`form_id` int NOT NULL,
`page_id` int NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE IF NOT EXISTS `#__formea_form_rows` (
`id` int NOT NULL AUTO_INCREMENT,
`row_type` tinyint NOT NULL DEFAULT '0',
`form_id` int NOT NULL,
`page_id` int NOT NULL DEFAULT '0',
`group_id` int NOT NULL DEFAULT '0',
`settings` text COLLATE utf8mb4_general_ci,
`styleSheet` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`class` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`gutterX` tinyint NOT NULL DEFAULT '-1',
`gutterY` tinyint NOT NULL DEFAULT '-1',
PRIMARY KEY (`id`),
INDEX(`row_type`,`form_id`,`page_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_groups` (
`id` int NOT NULL AUTO_INCREMENT,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
`alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`class` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`state` tinyint NOT NULL DEFAULT '0',
`inline_css` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`additional_css` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`inline_js` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`additional_js` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`group_type` tinyint NOT NULL DEFAULT '0',
`labelSettings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`styleSheet` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`access_level` int NOT NULL,
`params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`layout` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`checked_out` int UNSIGNED DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`created_by` int UNSIGNED NOT NULL DEFAULT '0',
`modified_date` datetime DEFAULT NULL,
`modified_by` int UNSIGNED NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_group_cores` (
`id` int NOT NULL AUTO_INCREMENT,
`group_id` int NOT NULL,
`enabled` tinyint NOT NULL DEFAULT '0',
`corename` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_submissions` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`user_id` int NOT NULL,
`language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
`ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
`state` tinyint NOT NULL DEFAULT '0',
`user_email_sent` tinyint NOT NULL DEFAULT '0',
`user_email` text COLLATE utf8mb4_general_ci,
`admin_email_sent` int NOT NULL,
`admin_email` text COLLATE utf8mb4_general_ci,
`submitted_url` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`submission_type` tinyint NOT NULL DEFAULT '0',
`transaction_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`payment_status` tinyint NOT NULL DEFAULT '0',
`payment_method` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`checked_out` int UNSIGNED DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`created_by` int UNSIGNED NOT NULL DEFAULT '0',
`modified_date` datetime DEFAULT NULL,
`modified_by` int UNSIGNED NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `idx_state` (`state`),
KEY `idx_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE IF NOT EXISTS `#__formea_submission_data` (
`id` int NOT NULL AUTO_INCREMENT,
`form_id` int NOT NULL,
`submission_id` int NOT NULL,
`group_id` int NOT NULL DEFAULT '0',
`setIndex` int NOT NULL DEFAULT '0',
`field_id` int NOT NULL DEFAULT '0' COMMENT 'element ID',
`field_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`field_text` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`field_caption` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
`field_value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
`is_link` tinyint NOT NULL DEFAULT '0',
`link_path` text COLLATE utf8mb4_general_ci,
`dir_path` text COLLATE utf8mb4_general_ci,
`field_access` int NOT NULL DEFAULT '-1',
`field_publish_up` datetime DEFAULT NULL,
`field_publish_down` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `idx_form_id` (`form_id`),
KEY `idx_submission_id` (`submission_id`),
KEY `field_id` (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_themes` (
`id` int NOT NULL AUTO_INCREMENT,
`name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`creation_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`copyright` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`license` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`state` tinyint NOT NULL DEFAULT '0',
`checked_out` int DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`modified_date` datetime DEFAULT NULL,
`modified_by` int NOT NULL DEFAULT '0',
`created_by` int NOT NULL DEFAULT '0',
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__formea_validations` (
`id` int NOT NULL AUTO_INCREMENT,
`name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`creation_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`copyright` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`license` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`author_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
`description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
`state` tinyint NOT NULL DEFAULT '0',
`checked_out` int DEFAULT NULL,
`checked_out_time` datetime DEFAULT NULL,
`created_date` datetime DEFAULT NULL,
`modified_date` datetime DEFAULT NULL,
`modified_by` int NOT NULL DEFAULT '0',
`created_by` int NOT NULL DEFAULT '0',
`publish_up` datetime DEFAULT NULL,
`publish_down` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
