<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Joomla\Component\Formea\Administrator\Controller;

	defined('_JEXEC') or die;

	use Exception;
	use Joomla\CMS\Factory;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\MVC\Controller\AdminController;
	use Joomla\CMS\MVC\Model\BaseDatabaseModel;
	use Joomla\CMS\Router\Route;
	use Joomla\Component\Formea\Administrator\Model\DashboardModel;

	/**
	 * Formea list controller class.
	 *
	 * @since  1.0.0
	 */
	class DashboardController extends AdminController
	{
		/**
		 * The prefix to use with controller messages.
		 *
		 * @var    string
		 * @since  1.0.0
		 */
		protected $text_prefix = 'COM_FORMEA';


		/**
		 * Proxy for getModel.
		 *
		 * @param   string  $name    The name of the model.
		 * @param   string  $prefix  The prefix for the PHP class name.
		 * @param   array   $config  Array of configuration parameters.
		 *
		 * @return  BaseDatabaseModel
		 *
		 * @since   1.0.0
		 */
		public function getModel($name = 'Dashboard', $prefix = 'Administrator', $config = ['ignore_request' => true])
		{
			return parent::getModel($name, $prefix, $config);
		}

		/**
		 * Install a formea plugin
		 */
		public function install()
		{
			$this->checkToken();
			$app    = Factory::getApplication();
      $plugin = $app->getInput()->files->getRaw('plugin_package',[]);
			/** @var DashboardModel $model */
			$model = $this->getModel();

			try
			{
        if(empty($plugin)){
          throw new Exception(Text::_('COM_FORMEA_NOT_FILE_UPLOADED'));
        }
				$model->installPlugin($plugin);
				$this->setRedirect(Route::_('index.php?option=com_formea&view=dashboard', false));
			}
			catch (Exception $e)
			{
				$this->app->enqueueMessage($e->getMessage(), 'error');
				$this->setRedirect(Route::_('index.php?option=com_formea&view=dashboard', false), Text::_('COM_FORMEA_PLUGIN_INSTALL_ERROR'), 'error');
			}
		}
	}
