<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	namespace Joomla\Component\Formea\Administrator\Controller;

	defined('_JEXEC') or die;

	use Feseur\Library\FsrResponse;
	use Joomla\CMS\MVC\Controller\FormController;
	use Joomla\CMS\Router\Route;
  use Joomla\Component\Formea\Administrator\Model\FormeaModel;
  use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;

	/**
	 * Controller for a single formea
	 *
	 * @since  1.0
	 */
	class FormeaController extends FormController
	{
		/**
		 * The prefix to use with controller messages.
		 *
		 * @var    string
		 * @since  1.0.0
		 */
		protected $text_prefix = 'COM_FORMEA_FORMEA';

		/**
		 * Method to run batch operations.
		 *
		 * @param   object  $model  The model.
		 *
		 * @return  boolean   True if successful, false otherwise and internal error is set.
		 *
		 * @since   1.0
		 */
		public function batch($model = null)
		{
			$this->checkToken();

			$model = $this->getModel('Formea', 'Administrator', array());

			// Preset the redirect
			$this->setRedirect(Route::_('index.php?option=com_formea&view=formeas' . $this->getRedirectToListAppend(), false));

			return parent::batch($model);
		}

		public function getInstalledVersion()
		{

			$version  = FormeaGeneralHelper::getCurrentVersion();
			$response = new FsrResponse();
			$response->setSuccess(true);
			$response->setResult([
				'version' => $version
			]);
			echo json_encode($response);
			$this->app->close();
		}

    public function getAttachments(){
      $this->checkToken('GET');
      $formId  = $this->input->getInt('formId', 0);
      $emailId = $this->input->getInt('emailId', 0);
      $langTag = $this->input->getString('langTag', 'en-GB');

      /** @var FormeaModel $model */
      $model = $this->getModel('Formea', 'Administrator', array());
      $response = $model->getAttachments($formId,$emailId,$langTag);
      $view = $this->getView('Formea', 'json');
      $view->retObject = $response;
      $view->display();

      return true;
    }
    public function getAttachmentFileInfo(){
      $this->checkToken();
      $filePaths      = $this->input->get('filePath', [], 'ARRAY');

      /** @var FormeaModel $model */
      $model = $this->getModel('Formea', 'Administrator', array());
      $response = $model->getAttachmentFileInfo($filePaths);
      $view = $this->getView('Formea', 'json');
      $view->retObject = $response;
      $view->display();

      return true;
    }
	}
