<?php
  /**
   * @package     Joomla.Administrator
   * @subpackage  com_formea
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
   */

  namespace Joomla\Component\Formea\Administrator\Controller;

  defined('_JEXEC') or die;

  use Exception;
  use Joomla\CMS\Factory;
  use Joomla\CMS\Language\Text;
  use Joomla\CMS\MVC\Controller\FormController;
  use Joomla\CMS\Router\Route;
  use Joomla\Component\Formea\Administrator\Model\ValidationModel;

  /**
   * Controller for a single formea
   *
   * @since  1.0
   */
  class ValidationController extends FormController
  {
    /**
     * The prefix to use with controller messages.
     *
     * @var    string
     * @since  1.0.0
     */
    protected $text_prefix = 'COM_FORMEA';

    public function save($key = null, $urlVar = null)
    {
      $saved = parent::save($key, $urlVar); // TODO: Change the autogenerated stub

    }

    /**
     * Method to run batch operations.
     *
     * @param   object  $model  The model.
     *
     * @return  boolean   True if successful, false otherwise and internal error is set.
     *
     * @since   1.0
     */
    public function batch($model = null)
    {
      $this->checkToken();

      $model = $this->getModel('Validation', 'Administrator', array());

      // Preset the redirect
      $this->setRedirect(Route::_('index.php?option=com_formea&view=validations' . $this->getRedirectToListAppend(), false));

      return parent::batch($model);
    }

    /**
     * Install a validation plugin
     */
    public function install()
    {
      $this->checkToken();
      $app    = Factory::getApplication();
      $plugin = $app->getInput()->files->getRaw('plugin_package',[]);

      /** @var ValidationModel $model */
      $model = $this->getModel('validation');

      try
      {
        if(empty($plugin)){
          throw new Exception(Text::_('COM_FORMEA_NOT_FILE_UPLOADED'));
        }
        $model->install($plugin);
        $this->setRedirect(Route::_('index.php?option=com_formea&view=validations', false), Text::_('COM_FORMEA_VALIDATION_PLUGIN_INSTALLED'));
      }
      catch (Exception $e)
      {
        $this->app->enqueueMessage($e->getMessage(), 'error');
        $this->setRedirect(Route::_('index.php?option=com_formea&view=validations', false), Text::_('COM_FORMEA_VALIDATION_PLUGIN_INSTALL_ERROR'));
      }
    }
  }
