<?php
  /**
   * @package     Joomla.Administrator
   * @subpackage  com_formea
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

  namespace Joomla\Component\Formea\Administrator\View\Submission;

  defined('_JEXEC') or die;

  use Exception;
  use Joomla\CMS\Application\CMSApplicationInterface;
  use Joomla\CMS\Factory;
  use Joomla\Component\Formea\Site\Libraries\FormeaAttachment;
  use Joomla\Filesystem\Folder;
  use Joomla\CMS\Form\Form;
  use Joomla\CMS\Helper\ContentHelper;
  use Joomla\CMS\Language\Text;
  use Joomla\CMS\Router\Route;
  use Joomla\CMS\Toolbar\ToolbarHelper;
  use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;
  use Joomla\Component\Formea\Administrator\Model\FormeaModel;
  use Joomla\Component\Formea\Administrator\View\FormeaView;
  use Joomla\Filesystem\Path;


  /**
   * View to edit a formea.
   *
   * @since  1.0.0
   */
  class HtmlView extends FormeaView
  {
    /**
     * The Form object
     *
     * @var    Form
     * @since  1.0.0
     */
    public $form;

    /**
     * The active item
     *
     * @var    object
     * @since  1.0.0
     */
    public $item;

    /**
     * @var CMSApplicationInterface
     * @since 1.0.0
     */
    protected $app;

    /**
     * @var array
     * @since 1.2.0
     */
    public $iconSets;


    /**
     * Display the view.
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  mixed  A string if successful, otherwise an Error object.
     *
     * @throws  Exception
     * @since   1.0.0
     */
    public function display($tpl = null)
    {
      $this->app = Factory::getApplication();
      $id        = $this->app->getInput()->getInt('id', 0);
      if ($id < 1)
      {
        $this->app->enqueueMessage(Text::_('COM_FORMEA_INVALID_VALIDATION_ITEM'), 'error');
        $this->app->redirect(Route::_('index.php?option=com_formea&view=submissions', false));
      }

      /** @var FormeaModel $model */
      $model            = $this->getModel();
      $this->item       = $model->getItem();
      $formeaAttachment = new FormeaAttachment();
      $this->iconSets   = $formeaAttachment->getIconSets();
      $this->addToolbar();

      return parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @return  void
     *
     * @throws  Exception
     * @since   1.0.0
     */
    private function addToolbar(): void
    {
      $app = Factory::getApplication();
      $app->input->set('hidemainmenu', true);

      $user   = $app->getIdentity();
      $userId = $user->id;
      $isNew  = ($this->item->id == 0);

      $title = Text::_('COM_FORMEA_SUBMISSION');
      if (!empty($this->item->form_title))
      {
        $title .= ': ' . Text::_($this->item->form_title);
      }
      ToolbarHelper::title($title, 'key');
      $this->getDocument()->setTitle($title . ' - ' . Text::_('COM_FORMEA'));
      // Since we don't track these assets at the item level, use the category id.
      $canDo = ContentHelper::getActions('com_formea', 'component', $this->item->id);

      // Build the actions for new and existing records.
      if ($isNew)
      {
        // For new records, check the create permission.
        ToolbarHelper::cancel('submission.cancel');
      }
      else
      {
        // Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
        $itemEditable = $canDo->get('core.edit')
          || ($canDo->get('core.edit.own')
            && $this->item->created_by == $userId);

        ToolbarHelper::cancel('submission.cancel', 'JTOOLBAR_CLOSE');
      }
      ToolbarHelper::divider();
      ToolbarHelper::help('', false, FormeaHelper::getHelpLink('Submission'));
    }

    protected function _loadLanguage()
    {
      if (!empty($this->item))
      {
        $lang     = $this->app->getLanguage();
        $langTag  = $lang->getTag();
        $langPath = JPATH_ROOT . '/components/com_formea/plugins/submission/' . $this->item->name;
        if (is_dir(Path::clean($langPath . '/language/' . $langTag)))
        {
          $lang->load($this->item->name, $langPath, $langTag);
        }
      }
    }


  }
