<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\Factory;
	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\Router\Route;
	use Joomla\CMS\WebAsset\WebAssetManager;
	use Joomla\Component\Formea\Administrator\View\Coreextension\HtmlView;

	/** @var HtmlView $this */

	/** @var WebAssetManager $wa */
	$wa = $this->document->getWebAssetManager();
	$wa->useScript('keepalive')
		->useScript('form.validate');

	HTMLHelper::_('script', 'com_formea/admin-formeas-letter.js', array('version' => 'auto', 'relative' => true));

	$app             = Factory::getApplication();
	$input           = $app->input;
	$this->useCoreUI = true;

	// In case of modal
	$isModal = $input->get('layout') == 'modal' ? true : false;
	$layout  = $isModal ? 'modal' : 'edit';
	$tmpl    = $isModal || $input->get('tmpl', '') === 'component' ? '&tmpl=component' : '';
?>

<form
      action="<?php echo Route::_('index.php?option=com_formea&view=coreextension&layout=' . $layout . $tmpl . '&id=' . (int) $this->item->id); ?>"
      method="post" name="adminForm" id="formea-form" class="form-validate">
   <div class="main-card">
	   <?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'details')); ?>
	   <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_FORMEA_CORE')); ?>
      <div class="row">
         <div class="col-md-9">
            <h2><?php echo $this->item->title; ?></h2>
            <div class="info-labels mb-1">
               <span class="badge bg-secondary"> <?php echo Text::_('COM_FORMEA_CORE'); ?> </span> /
               <span class="badge bg-secondary"><?php echo $this->item->name; ?></span>
            </div>
            <div class="my-3">
				<?php echo Text::_($this->item->description); ?>
            </div>
			 <?php $paramGroup = $this->form->getGroup('params');
				 if (!empty($paramGroup))
				 { ?>
                    <hr>
					 <?php foreach ($paramGroup as $field)
				 {
					 echo $field->renderField();
				 } ?>
				 <?php } ?>
         </div>
         <div class="col-md-3">
			 <?php echo $this->form->renderField('state'); ?>
			 <?php echo $this->form->renderField('created_date'); ?>
			 <?php echo $this->form->renderField('created_by'); ?>
			 <?php echo $this->form->renderField('modified_date'); ?>
			 <?php echo $this->form->renderField('modified_by'); ?>
         </div>
      </div>
	   <?php echo HTMLHelper::_('uitab.endTab'); ?>
	   <?php if ($this->coreConfig->get('hasStyle', false)): ?>
		   <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'styles', Text::_('COM_FORMEA_STYLES')); ?>
		   <?php echo $this->form->renderField('styles'); ?>
		   <?php echo HTMLHelper::_('uitab.endTab'); ?>
	   <?php endif; ?>
	   <?php echo HTMLHelper::_('uitab.endTabSet'); ?>
   </div>

   <input type="hidden" name="task" value="">
	<?php echo $this->form->renderField('id'); ?>
	<?php echo $this->form->renderField('title'); ?>
	<?php echo $this->form->renderField('name'); ?>
	<?php echo $this->form->renderField('description'); ?>
	<?php echo $this->form->renderField('checked_out'); ?>
	<?php echo $this->form->renderField('checked_out_time'); ?>
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
