<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	defined('_JEXEC') or die;


	use Joomla\CMS\Language\Text;
	use Joomla\Component\Formea\Administrator\View\Element\HtmlView;


	/** @var HtmlView $this */
	$hasPlaceholder   = false;
	$placeholderLists = [];
	if (isset($this->elementType->config->elementConfig->hasPlaceholder))
	{
		$hasPlaceholder = $this->elementType->config->elementConfig->hasPlaceholder;
		if ($hasPlaceholder)
		{
			if (isset($this->elementType->config->elementConfig->placeholder))
			{
				$placeholderLists = $this->elementType->config->elementConfig->placeholder;
			}
		}
	}
?>
<div class="row">
   <div class="col-md-6">
	   <?php
		   foreach ($this->form->getFieldsets('params') as $set => $field)
		   { ?>
			   <?php echo $this->form->renderFieldset($set); ?>
		   <?php } ?>
   </div>
	<?php if ($hasPlaceholder && !empty($placeholderLists)):
		$totalPlaceholder = count($placeholderLists);
		?>
       <div class="col-md-6">
          <h5><?php echo Text::_('COM_FORMEA_AVAILABLE_PLACEHOLDERS'); ?></h5>
          <ul class="list-unstyled placeholder-static-list" id="key_placeholders">
			  <?php
				  for ($i = 0; $i < $totalPlaceholder; $i++)
				  {
					  ?>
                     <li>
						 <?php if ($placeholderLists[$i]->type === 1): ?>
                            <div class="d-block"><code> [<?php echo $placeholderLists[$i]->value; ?>]</code></div>
							 <?php if (!empty($placeholderLists[$i]->desc)): ?>
                               <div class="d-block text-muted small"><?php echo Text::_($placeholderLists[$i]->desc); ?></div>
							 <?php endif; ?>
						 <?php endif; ?>
                     </li>
				  <?php } ?>
          </ul>
       </div>
	<?php endif; ?>
</div>
