<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\Component\Formea\Administrator\View\Element\HtmlView;


	/** @var HtmlView $this */

	$totalLang        = $this->totalLanguages;
	$lTag             = str_replace('-', '_', $this->lang_tag);
	$hasPlaceholder   = false;
	$placeholderLists = [];
	$mainColumn       = 12;
	$secondaryColumn  = 0;
	if (isset($this->elementType->config->values->hasPlaceholder))
	{
		$hasPlaceholder = $this->elementType->config->values->hasPlaceholder;
		if ($hasPlaceholder)
		{
			if (isset($this->elementType->config->values->placeholder))
			{
				$placeholderLists = $this->elementType->config->values->placeholder;
			}
			if (!empty($placeholderLists))
			{
				$mainColumn      = 9;
				$secondaryColumn = 3;
			}
		}
	}
?>
<div class="row">
   <div class="col-md-<?php echo $mainColumn; ?>">
	   <?php
		   if ($this->isMultiLang && $totalLang > 1)
		   {
			   echo HTMLHelper::_('uitab.startTabSet', 'langTab', array('active' => $lTag));
			   for ($i = 0; $i < $totalLang; $i++)
			   {
				   $ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
				   echo HTMLHelper::_('uitab.addTab', 'langTab', $ltag, $this->languageLists[$i]->title);
				   echo $this->form->renderField('defval', 'elementvalues.' . $ltag);
				   if ($this->isOptionListVal)
				   {
					   echo $this->form->getInput('option_lists', 'elementvalues.' . $ltag);
				   }
				   else
				   {
					   echo $this->form->renderField('option_lists', 'elementvalues.' . $ltag);
				   }

				   echo HTMLHelper::_('uitab.endTab');
			   }
			   echo HTMLHelper::_('uitab.endTabSet');
		   }
		   else
		   {
			   if ($this->isOptionListVal)
			   {
				   echo $this->form->getInput('option_lists', 'elementvalues.' . $lTag);
			   }
			   else
			   {
				   echo $this->form->renderField('option_lists', 'elementvalues.' . $lTag);
			   }
			   echo $this->form->renderField('defval', 'elementvalues.' . $lTag);
			   // echo $this->form->renderField('option_lists', 'elementvalues.' . $lTag);
		   }
	   ?>
   </div>
	<?php if ($hasPlaceholder && !empty($placeholderLists)):
		$totalPlaceholder = count($placeholderLists);
		?>
       <div class="col-md-<?php echo $secondaryColumn; ?>">
          <h5><?php echo Text::_('COM_FORMEA_AVAILABLE_PLACEHOLDERS'); ?></h5>
          <ul class="list-unstyled placeholder-static-list" id="key_placeholders">
			  <?php
				  for ($i = 0; $i < $totalPlaceholder; $i++)
				  {
					  ?>
                     <li>
						 <?php if ($placeholderLists[$i]->type === 1): ?>
                            <div class="d-block"><code> [<?php echo $placeholderLists[$i]->value; ?>]</code></div>
							 <?php if (!empty($placeholderLists[$i]->desc)): ?>
                               <div class="d-block text-muted small"><?php echo Text::_($placeholderLists[$i]->desc); ?></div>
							 <?php endif; ?>
						 <?php endif; ?>
                     </li>
				  <?php } ?>
          </ul>
       </div>
	<?php endif; ?>

</div>
