<?php

	/**
	 * @package         Joomla.Administrator
	 * @subpackage      com_formea
	 *
	 * @copyright       Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license         GNU General Public License version 2 or later; see LICENSE.txt
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\Factory;
	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\Layout\LayoutHelper;
	use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;

	$displayData = [
		'textPrefix' => 'COM_FORMEA_ELEMENTS',
		'formURL'    => '',
		'createURL'  => '',
		'helpURL'    => FormeaHelper::getHelpLink('Elements'),
		'icon'       => 'fas fa-stream',
	];

	$user = Factory::getApplication()->getIdentity();


	echo LayoutHelper::render('joomla.content.emptystate', $displayData);

	echo HTMLHelper::_(
		'bootstrap.renderModal',
		'ElementSelectionModal',
		[
			'title'  => Text::_('COM_FORMEA_SELECT_ELEMENT'),
			'footer' => $this->loadTemplate('select_footer'),
		],
		$this->loadTemplate('select_body')
	);
