<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\Factory;
	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\Layout\LayoutHelper;
	use Joomla\CMS\Router\Route;
	use Joomla\CMS\WebAsset\WebAssetManager;
	use Joomla\Component\Formea\Administrator\View\Groupedelement\HtmlView;

	/** @var HtmlView $this */

	/** @var WebAssetManager $wa */
	$wa = $this->document->getWebAssetManager();
	$wa->useScript('keepalive')
		->useScript('form.validate');

	HTMLHelper::_('script', 'com_formea/admin-formeas-letter.js', array('version' => 'auto', 'relative' => true));

	$app             = Factory::getApplication();
	$input           = $app->input;
	$this->useCoreUI = true;

	// In case of modal
	$isModal = $input->get('layout') == 'modal' ? true : false;
	$layout  = $isModal ? 'modal' : 'edit';
	$tmpl    = $isModal || $input->get('tmpl', '') === 'component' ? '&tmpl=component' : '';
?>

<form
      action="<?php echo Route::_('index.php?option=com_formea&view=groupedelement&layout=' . $layout . $tmpl . '&id=' . (int) $this->item->id); ?>"
      method="post" name="adminForm" id="formea-form" class="form-validate">
   <div class="d-none hidden">
      <div>
         <input type="text" id="edit_element_id" placeholder="edit element id" class="form-control"
                oninput="FormeaElementIdChange()">
      </div>
      <div>
         <input type="text" id="edit_element_name" placeholder="edit element name" class="form-control">
      </div>
   </div>
   <div class="row">
      <div class="col-md-7">
		  <?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>
      </div>
      <div class="col-md-5">
         <div class="row">
            <div class="col-md-6">
				<?php echo $this->getForm()->renderField('state'); ?>
            </div>
            <div class="col-md-6">
				<?php echo $this->getForm()->renderField('access_level'); ?>
            </div>
         </div>
      </div>
   </div>
   <div class="main-card no-tab-padding">
	   <?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'details')); ?>
	   <?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'details', Text::_('COM_FORMEA_ELEMENT_LAYOUTS'));
	   ?>
      <div class="d-block pt-4">
		  <?php echo $this->form->getInput('elementlayout'); ?>
      </div>
	   <?php
		   echo HTMLHelper::_('uitab.endTab');
		   echo HTMLHelper::_('uitab.addTab', 'myTab', 'labelSetting', Text::_('COM_FORMEA_CAPTION_LBL'));
		   echo '<div class="d-block p-3">';
		   echo $this->loadTemplate('labelsetting');
		   echo '</div>';
		   echo HTMLHelper::_('uitab.endTab');
		   echo HTMLHelper::_('uitab.addTab', 'myTab', 'additional_style_script', Text::_('COM_FORMEA_CSS_JAVASCRIPT'));
		   echo '<div class="d-block p-3">';
		   echo $this->loadTemplate('cssjs');
		   echo '</div>';
		   echo HTMLHelper::_('uitab.endTab');
		   if ($this->hasCoreExtensions)
		   {
			   echo HTMLHelper::_('uitab.addTab', 'myTab', 'cores', Text::_('COM_FORMEA_CORE_TAB'));
			   echo '<div class="d-block p-3">';
			   echo $this->loadTemplate('cores');
			   echo '</div>';
			   echo HTMLHelper::_('uitab.endTab');
		   }
		   echo HTMLHelper::_('uitab.endTabSet'); ?>
   </div>

   <input type="hidden" name="task" value="">
	<?php echo $this->form->renderField('id');
		echo $this->form->getInput('group_type');
		echo $this->form->renderField('checked_out');
		echo $this->form->renderField('checked_out_time');
		echo HTMLHelper::_('form.token'); ?>
</form>

<?php
	$title                      = Text::_('COM_FORMEA_ELEMENT');
	$link                       = 'index.php?option=com_formea&task=element.edit&type=JoomlaCaptcha&id=0&layout=modal&tmpl=component';
	$randomId                   = $title;
	$modalParams['title']       = $this->escape($title);
	$modalParams['footer']      = $this->loadTemplate('element_footer');
	$modalParams['url']         = $link;
	$modalParams['backdrop']    = 'static';
	$modalParams['keyboard']    = false;
	$modalParams['closeButton'] = false;
	$modalParams['height']      = '100%';
	$modalParams['width']       = '100%';
	$modalParams['bodyHeight']  = 70;
	$modalParams['modalWidth']  = 80;
	echo HTMLHelper::_('bootstrap.renderModal', 'modal-element', $modalParams);
?>
