<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\Component\Formea\Administrator\View\Formea\HtmlView;

	/** @var HtmlView $this */
	$totalLang = count($this->languageLists);
	$lTag      = str_replace('-', '_', $this->lang_tag);
?>
<div id="formea-labelSetting-jform">
	<?php
		if ($this->isMultiLang && $totalLang > 1)
		{
			echo HTMLHelper::_('uitab.startTabSet', 'langTabAdminEmail', array('active' => $lTag . 'admin_email_content', 'orientation' => 'horizontal'));
			for ($i = 0; $i < $totalLang; $i++)
			{
				$ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
				echo HTMLHelper::_('uitab.addTab', 'langTabAdminEmail', $ltag . 'admin_email_content', $this->languageLists[$i]->title);
				?>
               <div class="form-grid p-3">
				   <?php
					   echo $this->form->renderField('lang_code', 'labelSettings.' . $ltag, null, ['class' => 'control-label-sm']);
					   echo $this->form->renderField('lang_title', 'labelSettings.' . $ltag, null, ['class' => 'control-label-sm']);
					   echo $this->form->renderField('caption', 'labelSettings.' . $ltag, null, ['class' => 'control-label-sm']);
					   echo $this->form->renderField('description', 'labelSettings.' . $ltag, null, ['class' => 'control-label-sm']);
					   echo $this->form->renderField('show_label', 'labelSettings.' . $ltag . '.setting', null, ['class' => 'control-label-sm']);
					   echo $this->form->renderField('position', 'labelSettings.' . $ltag . '.setting', null, ['class' => 'control-label-sm w-30']);
					   echo $this->form->renderField('label_column', 'labelSettings.' . $ltag . '.setting', null, ['class' => 'control-label-sm w-30']);
					   echo $this->form->renderField('align', 'labelSettings.' . $ltag . '.setting', null, ['class' => 'control-label-sm w-30']);
					   echo $this->form->renderField('show_helper', 'labelSettings.' . $ltag, null, ['class' => 'control-label-sm']);
					   echo $this->form->renderField('helper_align', 'labelSettings.' . $ltag, null, ['class' => 'control-label-sm w-30']);
				   ?>
               </div>
				<?php
				echo HTMLHelper::_('uitab.endTab');
			}
			echo HTMLHelper::_('uitab.endTabSet');
		}
		else
		{
			?>
           <div class="form-grid">
			   <?php
				   echo $this->form->renderField('lang_code', 'labelSettings.' . $lTag, null, ['class' => 'control-label-sm']);
				   echo $this->form->renderField('lang_title', 'labelSettings.' . $lTag, null, ['class' => 'control-label-sm']);
				   echo $this->form->renderField('caption', 'labelSettings.' . $lTag, null, ['class' => 'control-label-sm']);
				   echo $this->form->renderField('description', 'labelSettings.' . $lTag, null, ['class' => 'control-label-sm']);
				   echo $this->form->renderField('show_label', 'labelSettings.' . $lTag . '.setting', null, ['class' => 'control-label-sm']);
				   echo $this->form->renderField('position', 'labelSettings.' . $lTag . '.setting', null, ['class' => 'control-label-sm w-30']);
				   echo $this->form->renderField('label_column', 'labelSettings.' . $lTag . '.setting', null, ['class' => 'control-label-sm w-30']);
				   echo $this->form->renderField('align', 'labelSettings.' . $lTag . '.setting', null, ['class' => 'control-label-sm w-30']);
				   echo $this->form->renderField('show_helper', 'labelSettings.' . $lTag, null, ['class' => 'control-label-sm']);
				   echo $this->form->renderField('helper_align', 'labelSettings.' . $lTag, null, ['class' => 'control-label-sm w-30']);
			   ?>

           </div>
			<?php
		}
	?>
</div>




