<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\Factory;
	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\Layout\LayoutHelper;
	use Joomla\CMS\Router\Route;
	use Joomla\CMS\Session\Session;
	use Joomla\Component\Formea\Administrator\View\Submissions\HtmlView;

	/** @var HtmlView $this */

	$user      = Factory::getApplication()->getIdentity();
	$userId    = $user->get('id');
	$listOrder = $this->escape($this->state->get('list.ordering'));
	$listDirn  = $this->escape($this->state->get('list.direction'));
	$saveOrder = $listOrder === 'a.ordering';

	if ($saveOrder && !empty($this->items))
	{
		$saveOrderingUrl = 'index.php?option=com_formea&task=submissions.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
		HTMLHelper::_('draggablelist.draggable');
	}


?>
<form action="<?php echo Route::_('index.php?option=com_formea&view=submissions'); ?>" method="post"
      enctype="multipart/form-data"
      name="adminForm" id="adminForm">
   <div class="row">
      <div class="col-md-12">
         <div id="j-main-container" class="j-main-container">
			 <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
			 <?php if (empty($this->items)) : ?>
                <div class="alert alert-warning">
					<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                </div>
			 <?php else : ?>
				 <?php if ($this->formId > 0)
				 {
					 echo $this->loadTemplate('singleform');
				 }
				 else
				 {
					 echo $this->loadTemplate('allforms');
				 } ?>

				 <?php echo $this->pagination->getListFooter(); ?>

			 <?php endif; ?>

            <input type="hidden" name="task" value="">
            <input type="hidden" name="boxchecked" value="0">
			 <?php echo HTMLHelper::_('form.token'); ?>
         </div>
      </div>
   </div>
</form>

