<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	defined('_JEXEC') or die;

	use Feseur\Library\FsrDate;
	use Joomla\CMS\Factory;
	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\Router\Route;
	use Joomla\Component\Formea\Administrator\View\Submissions\HtmlView;

	/** @var HtmlView $this */

	$user         = Factory::getApplication()->getIdentity();
	$userId       = $user->get('id');
	$listOrder    = $this->escape($this->state->get('list.ordering'));
	$listDirn     = $this->escape($this->state->get('list.direction'));
	$totalColumns = count($this->formColumns);
	$editIcon     = '<span class="fa fa-pencil-square me-2" aria-hidden="true"></span>';
?>
<div class="d-block text-center py-3">
   <p class="mb-0">Submissions for</p>
   <h3><?php echo $this->formName; ?></h3>
</div>

<div class="table-responsive">
   <table class="table itemList" id="formeaList">
      <caption class="visually-hidden">
		  <?php echo Text::_('COM_FORMEA_TABLE_CAPTION'); ?>,
         <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
         <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
      </caption>
      <thead>
      <tr>
         <th class="w-1 text-center">
			 <?php echo HTMLHelper::_('grid.checkall'); ?>
         </th>
         <th scope="col" class="w-10 d-none d-md-table-cell text-center">
			 <?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_DATE_SUBMITTED', 'a.created_date', $listDirn, $listOrder); ?>
         </th>
		  <?php for ($j = 0; $j < $totalColumns; $j++) { ?>
             <th>
				 <?php echo $this->formColumns[$j]->title; ?>
             </th>
		  <?php } ?>
         <th scope="col" class="w-3 d-none d-lg-table-cell">
			 <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
         </th>
         <th scope="col" class="w-3 d-none d-lg-table-cell">
         </th>
      </tr>
      </thead>
      <tbody>
	  <?php
		  foreach ($this->items as $i => $item) :
			  $canEdit = $user->authorise('core.edit', 'com_formea.submission.' . $item->id);
			  $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || is_null($item->checked_out);
			  $canEditOwn = $user->authorise('core.edit.own', 'com_formea.submission.' . $item->id) && $item->created_by == $userId;
			  $canChange = $user->authorise('core.edit.state', 'com_formea.submission.' . $item->id) && $canCheckin;
			  ?>
             <tr class="row<?php echo $i % 2; ?>">
                <td class="text-center">
					<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                </td>
                <td>
					<?php
						$date = new FsrDate($item->created_date);
						echo $date->format($this->formeaConfig->get('date_format', 'Y-m-d H:i:s'));
					?>
                </td>
				 <?php for ($j = 0; $j < $totalColumns; $j++) { ?>
                    <td>
						<?php
							if (!empty($item->submitted_data[$this->formColumns[$j]->id]))
							{
								if ($item->submitted_data[$this->formColumns[$j]->id]->is_link > 0)
								{
									?>
                                   <a href="<?php echo $item->submitted_data[$this->formColumns[$j]->id]->link_path; ?>"
                                      target="_blank">
									   <?php echo $item->submitted_data[$this->formColumns[$j]->id]->field_value; ?>
                                   </a>
								<?php }
								else
								{
									echo $item->submitted_data[$this->formColumns[$j]->id]->field_value;
								}
							}
							else
							{
								echo '&mdash;';
							}
						?>
                    </td>
				 <?php } ?>
                <td class="d-none d-md-table-cell">
					<?php echo $item->id; ?>
                </td>
                <th>
                   <a class="d-block"
                      href="<?php echo Route::_('index.php?option=com_formea&task=submission.edit&id=' . (int) $item->id); ?>"
                   >
					   <?php echo $editIcon; ?><?php echo $this->escape($item->form_title); ?></a>
                </th>
             </tr>
		  <?php endforeach; ?>
      </tbody>
   </table>
</div>

