<?php
  /**
   * @package     Formea.Plugin
   * @subpackage  element
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */
// no direct access
  defined('_JEXEC') or die();

  use Joomla\Component\Formea\Site\Libraries\FormeaElementAttribute;
  use Joomla\Component\Formea\Site\Libraries\FormeaEltype;

  class FormeaFormattedText extends FormeaEltype
  {


    public function __construct($config = [])
    {
      parent::__construct($config);
    }

    public function getLabel($label = 'label', $class = [], $preview = false)
    {
      return '';
    }

    public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
    {


      $forbiddenAttr = ['class', 'size', 'max-size', 'placeholder', 'value', 'max_size', 'additional_attr'];
      $gotDiv        = false;
      $html          = '';
      $first         = true;
      foreach ($inputAttributes as $attr => $v)
      {
        if (!in_array($attr, $forbiddenAttr))
        {
          $gotDiv = true;
          if ($first)
          {
            $first = false;
            $html  .= '<div ';
          }
          $html .= ' ' . $attr . '="' . $v . '" ';
        }
      }

      if ($gotDiv)
      {
        if ($this->isGroup && $this->group_type == 0)
        {
          $themeClass = $this->getThemeClass();
          $html       .= 'class="' . $themeClass->getFormGroupClass() . '"';
        }
        $html .= '>';
      }
      else
      {
        if ($this->isGroup && $this->group_type == 0)
        {
          $gotDiv     = true;
          $html       .= '<div ';
          $themeClass = $this->getThemeClass();
          $html       .= 'class="' . $themeClass->getInputGroupText() . '"';
          $html       .= '>';
        }
      }

      if (isset($inputAttributes['value']))
      {
        $html .= $inputAttributes['value'];
      }

      if ($gotDiv)
      {
        $html .= '</div>';
      }


      return $html;
    }

    public function renderField($preview = false, $langTag = '', $columnAttributes = [], $inputAttributes = [], $labelSetting = null)
    {
      $langTagUnderscore = str_replace('-', '_', $langTag);
      $columnClass       = ['fm_element_' . $this->form_id . '_' . $this->element_id];

      if (isset($columnAttributes['class']))
      {
        $columnClass[] = $columnAttributes['class'];
      }

      if (!empty($this->form_element_settings))
      {
        if (!empty($this->form_element_settings->get('containerClass')))
        {
          $columnClass[] = $this->form_element_settings->get('containerClass');
        }
      }

      $elementAttributeClass = new FormeaElementAttribute(['element_id' => $this->element_id]);

      if (!empty($elementAttributeClass))
      {
        $elementAttributes = $elementAttributeClass->getAttributes();
        if (!empty($elementAttributes->class))
        {
          $inputClass[] = $elementAttributes->class;
        }
        foreach ($elementAttributes as $attr => $val)
        {
          if ($attr !== 'class' && $attr !== 'additional_attr')
          {
            $inputAttributes[str_replace('_', '-', $attr)] = $val;
          }
        }
      }


      if (!empty($this->element_values))
      {
        if (isset($this->element_values[$langTagUnderscore]))
        {
          if (isset($this->element_values[$langTagUnderscore]['defval']))
          {
            $inputAttributes['value'] = $this->element_values[$langTagUnderscore]['defval'];
          }
        }
      }

      $forbiddenAttr = ['class', 'size', 'max-size', 'placeholder', 'value'];

      $html = '<div class="' . implode(' ', $columnClass) . '"';

      $html .= '>';

      $html .= $this->getInput([], $inputAttributes, $langTagUnderscore, $preview, $labelSetting);
      $html .= '</div>';

      return $html;
    }

    public function renderInputGroup($preview, $labelSetting)
    {
      $langTag    = $labelSetting->lang_code;
      $themeClass = $this->getThemeClass();

      $html = '<div class="' . $themeClass->getInputGroupText() . '">';
      $html .= $this->getBareInput($preview, $langTag, [], $labelSetting);
      $html .= '</div>';

      return $html;
    }

  }
