<?php
  /**
   * @package     Formea.Plugin
   * @subpackage  element
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */
// no direct access
  defined('_JEXEC') or die();

  use Feseur\Library\FsrResponse;
  use Joomla\Component\Formea\Site\Libraries\FormeaEltype;
  use Joomla\CMS\Plugin\PluginHelper;
  use Joomla\CMS\Factory;

  class FormeaJoomlaCaptcha extends FormeaEltype
  {
    public function __construct($config = [])
    {
      parent::__construct($config);
    }

    public function beforeValidatingInput($element)
    {
      $element->skip_value_store = true;

      return $element;
    }

    public function getLabel($label = 'label', $class = 'form-label', $preview = false)
    {
      return '';
    }

    public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
    {
      $input = '';
      if ($preview)
      {
        $input .= '<img src="' . Joomla\CMS\Uri\Uri::root() . 'media/com_formea/img/element/JoomlaCaptcha/RecaptchaLogo.svg"';
        $input .= 'style="width:100px;"/>';
      }
      else
      {

      }

      return $input;
    }

    public function renderField($preview = false, $langTag = '', $columnAttributes = [], $inputAttributes = [], $labelSetting = null)
    {
      $html = '';
      if (!$preview)
      {
        $elementId      = $this->formatElementId();
        $name           = $this->formatElementName();
        $captchaPlugins = PluginHelper::getPlugin('captcha');
        if (!empty($captchaPlugins))
        {
          if (isset($captchaPlugins[0]))
          {
            $captha = new Joomla\CMS\Captcha\Captcha($captchaPlugins[0]->name, json_decode($captchaPlugins[0]->params, true));
            $captha->initialise($elementId);
            $html = $captha->display($name, $elementId, '');
          }
        }

      }
      else
      {
        $html = $this->getInput('', [], $langTag, $preview);
      }

      return $html;
    }

    public function validateInput($submitted_value, $element, $validations = [])
    {
      $retObject      = new FsrResponse();
      $captchaPlugins = PluginHelper::getPlugin('captcha');
      $resultResponse = new FsrResponse();

      $result = (object) [
        'hasError' => true,
        'msg'      => 'Captcha Not Found'
      ];
      if (!empty($captchaPlugins))
      {
        if (isset($captchaPlugins[0]))
        {
          $app      = Factory::getApplication();
          $response = $app->getInput()->getString('g-recaptcha-response');
          $captha   = new Joomla\CMS\Captcha\Captcha($captchaPlugins[0]->name, json_decode($captchaPlugins[0]->params, true));
          $check    = $captha->checkAnswer($response);
          if ($check)
          {
            $result->hasError = false;
            $result->msg      = '';
            $resultResponse->setSuccess(true);

          }
          else
          {
            $result->hasError = true;
            $result->msg      = 'Captcha Failed.';
            $resultResponse->setSuccess(false);
            $resultResponse->setMsg('Captcha Failed.');
          }
        }
      }
      else
      {
        $resultResponse->setSuccess(false);
        $resultResponse->setMsg('Captcha Not Found');
      }
      $resultResponse->setResult($result);
      $retObject->setSuccess(true);
      $retObject->setResult([(object) ['validation_plugin' => 'INTERNALCAPTCHA', 'result' => $resultResponse]]);

      return $retObject;
    }

  }
