<?php
  /**
   * @package     Formea.Plugin
   * @subpackage  element
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */
// no direct access
  defined('_JEXEC') or die();

  use Joomla\Component\Formea\Site\Libraries\FormeaEltype;

  class FormeaTextbox extends FormeaEltype
  {
    public function __construct($config = [])
    {
      parent::__construct($config);
    }

    public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
    {
      $themeClass = $this->getThemeClass();
      if (empty($langTagUnderscore))
      {
        $langTagUnderscore = $this->langTagUnderscore;
      }


      $classAttr = [];

      $classAttr[] = $themeClass->getInputClass();
      if (!empty($class))
      {
        $classAttr = array_merge($classAttr, $class);
      }

      $input     = '<input class="' . implode(' ', $classAttr) . '" ';
      $inputType = 'text';
      if (!empty($this->params))
      {
        $inputType = $this->params->get('input_type', 'text');
      }
      $input .= 'type="' . $inputType . '"';
      if (!$preview)
      {
        $input .= 'name="' . $this->formatElementName() . '"';
      }

      foreach ($inputAttributes as $key => $value)
      {
        $input .= ' ' . $key . '="' . $value . '" ';
      }


      $input .= 'id="' . $this->formatElementId() . '" />';

      return $input;
    }
  }
