<?php

	/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator;

	use Egulias\EmailValidator\Result\InvalidEmail;
	use Egulias\EmailValidator\Validation\EmailValidation;

	class EmailValidator
	{
		/**
		 * @var EmailLexer
		 */
		private $lexer;

		/**
		 * @var Warning\Warning[]
		 */
		private $warnings = [];

		/**
		 * @var ?InvalidEmail
		 */
		private $error;

		public function __construct()
		{
			$this->lexer = new EmailLexer();
		}

		/**
		 * @param   string           $email
		 * @param   EmailValidation  $emailValidation
		 *
		 * @return bool
		 */
		public function isValid(string $email, EmailValidation $emailValidation)
		{
			$isValid        = $emailValidation->isValid($email, $this->lexer);
			$this->warnings = $emailValidation->getWarnings();
			$this->error    = $emailValidation->getError();

			return $isValid;
		}

		/**
		 * @return boolean
		 */
		public function hasWarnings()
		{
			return !empty($this->warnings);
		}

		/**
		 * @return array
		 */
		public function getWarnings()
		{
			return $this->warnings;
		}

		/**
		 * @return InvalidEmail|null
		 */
		public function getError()
		{
			return $this->error;
		}
	}
