<?php

/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator\Result;

	use Egulias\EmailValidator\Result\Reason\Reason;

	class InvalidEmail implements Result
	{
		private $token;
		/**
		 * @var Reason
		 */
		protected $reason;

		public function __construct(Reason $reason, string $token)
		{
			$this->token  = $token;
			$this->reason = $reason;
		}

		public function isValid(): bool
		{
			return false;
		}

		public function isInvalid(): bool
		{
			return true;
		}

		public function description(): string
		{
			return $this->reason->description() . " in char " . $this->token;
		}

		public function code(): int
		{
			return $this->reason->code();
		}

		public function reason(): Reason
		{
			return $this->reason;
		}

	}
