<?php

/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator\Result;

	use Egulias\EmailValidator\Result\Reason\EmptyReason;
	use Egulias\EmailValidator\Result\Reason\Reason;

	/**
	 * @psalm-suppress PropertyNotSetInConstructor
	 */
	class MultipleErrors extends InvalidEmail
	{
		/**
		 * @var Reason[]
		 */
		private $reasons = [];

		public function __construct()
		{
		}

		public function addReason(Reason $reason): void
		{
			$this->reasons[$reason->code()] = $reason;
		}

		/**
		 * @return Reason[]
		 */
		public function getReasons(): array
		{
			return $this->reasons;
		}

		public function reason(): Reason
		{
			return 0 !== count($this->reasons)
				? current($this->reasons)
				: new EmptyReason();
		}

		public function description(): string
		{
			$description = '';
			foreach ($this->reasons as $reason)
			{
				$description .= $reason->description() . PHP_EOL;
			}

			return $description;
		}

		public function code(): int
		{
			return 0;
		}
	}
