<?php

/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator\Validation;

	use RuntimeException;

	class DNSGetRecordWrapper
	{
		/**
		 * @param   string  $host
		 * @param   int     $type
		 */
		public function getRecords(string $host, int $type): DNSRecords
		{
			// A workaround to fix https://bugs.php.net/bug.php?id=73149
			/** @psalm-suppress InvalidArgument */
			set_error_handler(
				static function (int $errorLevel, string $errorMessage): ?bool {
					throw new RuntimeException("Unable to get DNS record for the host: $errorMessage");
				}
			);
			try
			{
				// Get all MX, A and AAAA DNS records for host
				return new DNSRecords(dns_get_record($host, $type));
			}
			catch (RuntimeException $exception)
			{
				return new DNSRecords([], true);
			} finally
			{
				restore_error_handler();
			}
		}
	}
