<?php

/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator\Validation;

	use Egulias\EmailValidator\EmailLexer;
	use Egulias\EmailValidator\Result\InvalidEmail;
	use Egulias\EmailValidator\Warning\Warning;

	interface EmailValidation
	{
		/**
		 * Returns true if the given email is valid.
		 *
		 * @param   string      $email       The email you want to validate.
		 * @param   EmailLexer  $emailLexer  The email lexer.
		 *
		 * @return bool
		 */
		public function isValid(string $email, EmailLexer $emailLexer): bool;

		/**
		 * Returns the validation error.
		 *
		 * @return InvalidEmail|null
		 */
		public function getError(): ?InvalidEmail;

		/**
		 * Returns the validation warnings.
		 *
		 * @return Warning[]
		 */
		public function getWarnings(): array;
	}
