<?php

/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator\Validation;

	use Egulias\EmailValidator\EmailLexer;
	use Egulias\EmailValidator\Result\InvalidEmail;
	use Egulias\EmailValidator\Result\Reason\RFCWarnings;

	class NoRFCWarningsValidation extends RFCValidation
	{
		/**
		 * @var InvalidEmail|null
		 */
		private $error;

		/**
		 * {@inheritdoc}
		 */
		public function isValid(string $email, EmailLexer $emailLexer): bool
		{
			if (!parent::isValid($email, $emailLexer))
			{
				return false;
			}

			if (empty($this->getWarnings()))
			{
				return true;
			}

			$this->error = new InvalidEmail(new RFCWarnings(), '');

			return false;
		}

		/**
		 * {@inheritdoc}
		 */
		public function getError(): ?InvalidEmail
		{
			return $this->error ?: parent::getError();
		}
	}
