<?php

/**
	 * This is a forked library modified for use in Formea extension,
	 * Credit goes to original author(s) Eduardo Gulias Davis at https://github.com/egulias/EmailValidator.
	 * See LICENSE
	 *
	 * @version     1.0.0
	 * @package     Formea Email Validation
	 * @subpackage  Lexer
	 * @author      Feseur Sdn Bhd
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
	 */

	namespace Egulias\EmailValidator\Validation;

	use Egulias\EmailValidator\EmailLexer;
	use Egulias\EmailValidator\EmailParser;
	use Egulias\EmailValidator\Result\InvalidEmail;
	use Egulias\EmailValidator\Result\Reason\ExceptionFound;
	use Exception;

	class RFCValidation implements EmailValidation
	{
		/**
		 * @var EmailParser|null
		 */
		private $parser;

		/**
		 * @var array
		 */
		private $warnings = [];

		/**
		 * @var ?InvalidEmail
		 */
		private $error;

		public function isValid(string $email, EmailLexer $emailLexer): bool
		{
			$this->parser = new EmailParser($emailLexer);
			try
			{
				$result         = $this->parser->parse($email);
				$this->warnings = $this->parser->getWarnings();
				if ($result->isInvalid())
				{
					/** @psalm-suppress PropertyTypeCoercion */
					$this->error = $result;

					return false;
				}
			}
			catch (Exception $invalid)
			{
				$this->error = new InvalidEmail(new ExceptionFound($invalid), '');

				return false;
			}

			return true;
		}

		public function getError(): ?InvalidEmail
		{
			return $this->error;
		}

		public function getWarnings(): array
		{
			return $this->warnings;
		}
	}
