<?php
  /**
   * @package     Joomla.Administrator
   * @subpackage  com_formea
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
   */

  namespace Joomla\Component\Formea\Site\Controller;

  defined('_JEXEC') or die;

  use Exception;
  use Feseur\Library\FsrResponse;
  use Joomla\CMS\Input\Input;
  use Joomla\CMS\Language\Text;
  use Joomla\CMS\MVC\Controller\BaseController;
  use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
  use Joomla\CMS\Response\JsonResponse;
  use Joomla\CMS\Uri\Uri;
  use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;
  use Joomla\Component\Formea\Site\Libraries\FormeaElements;
  use Joomla\Component\Formea\Site\Libraries\FormeaForm;
  use Joomla\Component\Formea\Site\Libraries\FormeaSubmission;
  use Joomla\Component\Formea\Site\Model\FormeaModel;
  use Joomla\Component\Formea\Site\Model\ValidateformModel;
  use Joomla\Filesystem\Path;


  class FormeaController extends BaseController
  {
    /**
     * Constructor.
     *
     * @param   array                   $config   An optional associative array of configuration settings.
     *                                            Recognized key values include 'name', 'default_task', 'model_path', and
     *                                            'view_path' (this list is not meant to be comprehensive).
     * @param   MVCFactoryInterface     $factory  The factory.
     * @param   CMSApplication          $app      The JApplication for the dispatcher
     * @param   Joomla\CMS\Input\Input  $input    Input
     *
     * @since   1.0
     */
    public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
      parent::__construct($config, $factory, $app, $input);
    }

    public function submit()
    {
      $this->checkToken() or die('Invalid Token');
      $return_url = $this->input->getString('return_url');
      if (!empty($return_url))
      {
        $return_url = base64_decode($return_url);
      }
      else
      {
        $return_url = Uri::root();
      }
      /** @var FormeaModel $model */
      $model = $this->getModel('Formea', '', []);
      $ret   = $model->submit();
      if($ret->result->submissionMsgs->message_type === 'joomla'){
        $totalMesgs = count($ret->msg);
        for ($i = 0; $i < $totalMesgs; $i++)
        {
          if ($ret->msg[$i]->show)
          {
            $this->setMessage(strip_tags($ret->msg[$i]->text), $ret->msg[$i]->type);
          }
        }
      }


      if ($ret->success)
      {
        if ($ret->result->redirect && !empty($ret->result->redirectUrl))
        {
          $return_url = $ret->result->redirectUrl;
          //probably trigget email here
          FormeaGeneralHelper::checkSubmission();
        }
      }

      $this->setRedirect($return_url);

    }

    public function submitAjax()
    {
      $this->checkToken() or die('Invalid Token');
      $return_url = $this->input->getString('return_url');
      if (!empty($return_url))
      {
        $return_url = base64_decode($return_url);
      }
      else
      {
        $return_url = Uri::root();
      }
      /** @var FormeaModel $model */
      $model           = $this->getModel();
      $view            = $this->getView('Formea', 'json');
      $view->retObject = $model->submit();

      // Display the view
      $view->display();
    }

    public function validateForm()
    {
      $this->checkToken() or die('Invalid Token');
      $return_url = $this->input->getString('return_url');
      if (!empty($return_url))
      {
        $return_url = base64_decode($return_url);
      }
      else
      {
        $return_url = Uri::root();
      }

      /** @var FormeaModel $model */
      $model = $this->getModel('Formea', '', []);
      $ret   = $model->validateForm();

    }

    public function checkSubmission()
    {
      $this->checkToken() or die('Invalid Token');

      $ret = ['hasError' => false];

      $session             = $this->app->getSession();
      $formeaSubmittedData = $session->get('FORMEA_SUBMITTED_DATA');
      if (!empty($formeaSubmittedData))
      {
        foreach ($formeaSubmittedData as $submission_id => $data)
        {
          $formeaSubmission = new FormeaSubmission($submission_id);
          $sendMail         = $formeaSubmission->sendMail($data);
          if (!$sendMail->success)
          {
            $ret['hasError'] = true;
          }
          unset($formeaSubmittedData[$submission_id]);
        }
        $session = $this->app->getSession();
        if (empty($formeaSubmittedData))
        {
          $formeaSubmittedData = [];
        }
        $session->set('FORMEA_SUBMITTED_DATA', $formeaSubmittedData);
      }
      $jsonResponse = new JsonResponse($ret);
      echo $jsonResponse;
      $this->app->close();
    }

    /**
     *
     *
     * @throws Exception
     * @since 1.0.6
     */
    public function coreExtensionApiCall()
    {
      $retObject = new FsrResponse();
      try
      {
        $failed = true;
        if ($this->checkToken('post', false))
        {
          $failed = false;
        }
        elseif ($this->checkToken('get', false))
        {
          $failed = false;
        }

        if ($failed)
        {
          throw new Exception('Invalid token');
        }
        $methodName    = $this->input->get('methodName');
        $extensionName = $this->input->get('extensionName');
        $config        = $this->input->get('config', [], 'ARRAY');
        $args          = $this->input->get('args', [], 'ARRAY');
        $showView      = $this->input->getInt('showView', 1);
        $clsName       = 'Formea' . $extensionName;
        $targetFile    = $clsName . '.php';
        if (!is_file(Path::clean(FORMEA_CORE_PATH . '/' . $extensionName . '/' . $targetFile)))
        {
          throw new Exception('Invalid Core');
        }
        require_once FORMEA_CORE_PATH . '/' . $extensionName . '/' . $targetFile;
        if (!class_exists($clsName) || !method_exists($clsName, $methodName))
        {
          throw new Exception('Invalid method');
        }
        $class  = new $clsName($config);
        $result = $class->{$methodName}($args);

        $retObject->setResult($result);
        $retObject->setSuccess(true);
      }
      catch (Exception $e)
      {
        $retObject->setSuccess(false);
        $retObject->setMsg($e->getMessage());
      }
      if ($showView > 0)
      {
        $view            = $this->getView('Formea', 'json');
        $view->retObject = $retObject;
        $view->display();
      }
      else
      {
        return true;
      }
    }

  }
