<?php
	/**
	 * @package     Joomla.Administrator
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	namespace Joomla\Component\Formea\Site\Controller;

	defined('_JEXEC') or die;

	use Exception;
	use Joomla\CMS\Input\Input;
	use Joomla\CMS\MVC\Controller\BaseController;
	use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
	use Joomla\CMS\Uri\Uri;
	use Joomla\Component\Formea\Site\Model\ValidateformModel;


	class ValidateformController extends BaseController
	{
		/**
		 * The URL view item variable.
		 *
		 * @var    string
		 * @since  4.0.0
		 */
		protected $view_item = 'validateform';

		/**
		 * Constructor.
		 *
		 * @param   array                $config   An optional associative array of configuration settings.
		 *                                         Recognized key values include 'name', 'default_task', 'model_path', and
		 *                                         'view_path' (this list is not meant to be comprehensive).
		 * @param   MVCFactoryInterface  $factory  The factory.
		 * @param   CMSApplication       $app      The JApplication for the dispatcher
		 * @param   Joomla\CMS\Input\Input              $input    Input
		 *
		 * @since   1.0
		 */
		public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null)
		{
			parent::__construct($config, $factory, $app, $input);
		}

		public function getModel($name = 'Validateform', $prefix = '', $config = [])
		{
			return parent::getModel($name, $prefix, $config); // TODO: Change the autogenerated stub
		}

		public function page()
		{
			$this->checkToken() or die('Invalid Token');
			$return_url = $this->input->getString('return_url');
			if (!empty($return_url))
			{
				$return_url = base64_decode($return_url);
			}
			else
			{
				$return_url = Uri::root();
			}

			/** @var ValidateformModel $model */
			$model           = $this->getModel('Validateform', '', []);
			$view            = $this->getView('Validateform', 'json');
			$view->retObject = $model->validatePage();

			// Display the view
			$view->display();

		}

		public function form()
		{
			$this->checkToken() or die('Invalid Token');
			$return_url = $this->input->getString('return_url');
			if (!empty($return_url))
			{
				$return_url = base64_decode($return_url);
			}
			else
			{
				$return_url = Uri::root();
			}

			/** @var ValidateformModel $model */
			$model           = $this->getModel('Validateform', '', []);
			$view            = $this->getView('Validateform', 'json');
			$view->retObject = $model->validateForm();

			// Display the view
			$view->display();

		}
	}
