<?php
    /**
     * @package     Joomla.Site
     * @subpackage  com_formea
     *
     * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
     * @license     GNU General Public License version 2 or later; see LICENSE.txt
     * @version     1.2.2
     * @since       1.2.0
     */

    namespace Joomla\Component\Formea\Site\Libraries;

    class FormeaAttachmentFile
    {
        public $type = "";
        public $name = "";
        public $path = "";
        public $cleaned_path = "";
        public $extension = "";
        public $size = 0;
        public $mime_type = "";
        public $width = 0;
        public $height = 0;
        public $create_date = "";
        public $create_date_formatted = "";
        public $modified_date = "";
        public $modified_date_formatted = "";
        public $url = "";
        public $thumb_path = "";
        public $adapter = "";
        public $icon_name = "";

        public function __construct($config = array())
        {
            if (isset($config['type'])) {
                $this->type = $config['type'];
            }
            if (isset($config['name'])) {
                $this->name = $config['name'];
            }
            if (isset($config['path'])) {
                $this->path = $config['path'];
            }
            if (isset($config['cleaned_path'])) {
                $this->cleaned_path = $config['cleaned_path'];
            }
            if (isset($config['extension'])) {
                $this->extension = $config['extension'];
            }
            if (isset($config['size'])) {
                $this->size = $config['size'];
            }
            if (isset($config['mime_type'])) {
                $this->mime_type = $config['mime_type'];
            }
            if (isset($config['width'])) {
                $this->width = $config['width'];
            }
            if (isset($config['height'])) {
                $this->height = $config['height'];
            }
            if (isset($config['create_date'])) {
                $this->create_date = $config['create_date'];
            }
            if (isset($config['create_date_formatted'])) {
                $this->create_date_formatted = $config['create_date_formatted'];
            }
            if (isset($config['modified_date'])) {
                $this->modified_date = $config['modified_date'];
            }
            if (isset($config['modified_date_formatted'])) {
                $this->modified_date_formatted = $config['modified_date_formatted'];
            }
            if (isset($config['url'])) {
                $this->url = $config['url'];
            }
            if (isset($config['thumb_path'])) {
                $this->thumb_path = $config['thumb_path'];
            }
            if (isset($config['adapter'])) {
                $this->adapter = $config['adapter'];
            }
            if (isset($config['icon_name'])) {
                $this->icon_name = $config['icon_name'];
            }

            if (empty($this->icon_name)) {
                $this->icon_name = $this->getIconName($this->mime_type);
            }


        }


        public function getIconName(string $mime): string
        {
            $iconName = 'file';
            if (!empty($mime)) {
                $imageMimes = [
                    'image/png',
                    'image/jpeg',
                    'image/jpg',
                    'image/gif',
                    'image/bmp',
                    'image/webp',
                ];

                $compressedMimes = [
                    'application/gzip',
                    'application/x-zip',
                    'application/x-zip-compressed',
                    'application/octet-stream',
                    'application/x-compress',
                    'application/x-compressed',
                    'multipart/x-zip',
                    'application/zip',
                    'application/x-tar',
                ];

                $audioMimes = [
                    'audio/midi',
                    'audio/mpeg',
                    'audio/ogg',
                    'audio/aac',
                    'audio/wav',
                    'audio/webm',
                    'audio/x-ms-wma',
                ];

                $videoMimes = [
                    'video/mp4',
                    'video/mpeg',
                    'video/ogg',
                    'video/x-msvideo',
                    'video/3gpp',
                    'video/3gpp2',
                    'video/webm',
                    'video/x-ms-wmv',
                ];

                if ($mime === 'application/pdf') {
                    $iconName = 'pdf';
                } elseif (in_array($mime, $imageMimes)) {
                    $iconName = 'image';
                } elseif (in_array($mime, $compressedMimes)) {
                    $iconName = 'compressed';
                } elseif (in_array($mime, $audioMimes)) {
                    $iconName = 'audio';
                } elseif (in_array($mime, $videoMimes)) {
                    $iconName = 'video';
                }
            }


            return $iconName;
        }


    }
