<?php
	/**
	 * @package     Joomla.Site
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	namespace Joomla\Component\Formea\Site\Libraries;

	defined('_JEXEC') or die;

	use Feseur\Library\FsrFieldQuery;
	use Joomla\CMS\Factory;
	use Joomla\Database\DatabaseDriver;

	class FormeaForms
	{
		public function __construct()
		{
		}

		/**
		 * @param   boolean          $isCount
		 * @param   array            $db_limit
		 * @param   array            $ordering
		 * @param   FsrFieldQuery[]  $whereClause
		 *
		 *
		 * @since 1.0.0
		 */
		public function get($isCount = false, $fieldType = ['*'], $db_limit = [], $ordering = ['a.id' => 'DESC'], $whereClause = [])
		{
			if ($isCount)
			{
				$ret = $this->_totalItems($whereClause);
			}
			else
			{
				$ret = $this->_getForms($fieldType, $db_limit, $ordering, $whereClause);
			}

			return $ret;
		}

		/**
		 * @param   string[]         $fieldType
		 * @param                    $db_limit
		 * @param                    $ordering
		 * @param   FsrFieldQuery[]  $whereClause
		 *
		 *
		 * @since version
		 */
		protected function _getForms($fieldType = ['a.*'], $db_limit = [], $ordering = ['a.id' => 'DESC'], array $whereClause = [])
		{
			$ret    = [];
			$limit  = 5;
			$offset = 0;
			if (!empty($db_limit))
			{
				if (isset($db_limit['limit']))
				{
					$limit = (int) $db_limit['limit'];
				}
				if (isset($db_limit['offset']))
				{
					$offset = (int) $db_limit['offset'];
				}
			}
			$container = Factory::getContainer();
			/** @var DatabaseDriver $db */
			$db    = $container->get('DatabaseDriver');
			$query = $db->getQuery(true);
			$query->select($fieldType);
			$query->from($db->quoteName('#__formea_forms', 'a'));
			if (!empty($whereClause))
			{
				foreach ($whereClause as $clause)
				{
					$v = $db->quote($clause->value);
					if ($clause->value[0] == '(' && $clause->value[strlen($clause->value) - 1] == ')')
					{
						$v = $clause->value;
					}
					$query->where(
						$db->quoteName($clause->field) . ' ' .
						$clause->operator . ' ' .
						$v
					);
				}
			}

			if ($limit > 0)
			{
				$query->setLimit($limit, $offset);
			}
			foreach ($ordering as $column => $direction)
			{
				$query->order($db->quoteName($column) . ' ' . $direction);
			}
			$db->setQuery($query);

			return $db->loadObjectList();
		}


		/**
		 * Get the total row in DB
		 *
		 * @param   FsrFieldQuery[]  $whereClause
		 *
		 * @return int
		 *
		 * @since 1.0.0
		 */
		protected function _totalItems($whereClause = [])
		{
			$container = Factory::getContainer();
			/** @var DatabaseDriver $db */
			$db    = $container->get('DatabaseDriver');
			$query = $db->getQuery(true);
			$query->select('COUNT(*)');
			$query->from($db->quoteName('#__formea_forms'));
			if (!empty($whereClause))
			{
				foreach ($whereClause as $clause)
				{
					$v = $db->quote($clause->value);
					if ($clause->value[0] == '(' && $clause->value[strlen($clause->value) - 1] == ')')
					{
						$v = $clause->value;
					}
					$query->where(
						$db->quoteName($clause->field) . ' ' .
						$clause->operator . ' ' .
						$v
					);
				}
			}
			$db->setQuery($query);

			return (int) $db->loadResult();
		}
	}
