<?php
  /**
   * @package     Joomla.Site
   * @subpackage  com_formea
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
   */

  namespace Joomla\Component\Formea\Site\Libraries;

  defined('_JEXEC') or die;

  use Joomla\CMS\Factory;
  use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;
  use Joomla\Database\DatabaseDriver;
  use Joomla\Registry\Registry;
  use stdClass;

  class FormeaGridItem
  {
    /**
     * @var int
     * @since 1.0.0
     */
    public $formId = 0;

    /**
     * @var int
     * @since 1.0.0
     */
    public $group_id = 0;

    /**
     * @var bool
     * @since 1.0.0
     */
    public $isGroup = false;

    /**
     * @var int
     * @since 1.0.0
     */
    public $id = 0;

    /**
     * @var int
     * @since 1.0.0
     */
    public $item_type = 0;

    /**
     * @var FormeaGridItem[]
     * @since 1.0.0
     */
    public $items = [];

    /**
     * @var int
     * @since 1.0.0
     */
    public $column = 12;

    /**
     * @var int
     * @since 1.0.0
     */
    public $gutterX = -1;

    /**
     * @var int
     * @since 1.0.0
     */
    public $gutterY = -1;
    /**
     * @var stdClass | FormeaGridElement | null
     * @since 1.0.0
     */
    public $content = null;

    /**
     * @var Registry|array
     * @since 1.0.0
     */
    public $settings;

    /**
     * @var int
     * @since 1.0.0
     */
    public $nextColumnIdx = 0;

    /**
     * The element CSS class
     * @var string
     * @since 1.0.0
     */
    public $class = '';

    /**
     * @var string
     * @since 1.0.0
     */
    public $styleSheet = '';

    /**
     * @var bool
     * @since 1.0.0
     */
    public $active = false;

    /**
     * @var int
     * @since 1.0.0
     */
    public $group_type;

    /**
     * @var array|null
     * @since 1.0.0
     */
    public $inputGroupItem;

    /**
     * @var array
     * @since 1.0.0
     */
    public $sets = [];

    /**
     * @var int
     * @since 1.0.0
     */
    public $state = 0;

    public function __construct($config = [], $settingRegistry = true)
    {

      if (isset($config['state']))
      {
        $this->state = $config['state'];
      }

      if (isset($config['formId']))
      {
        $this->formId = $config['formId'];
      }
      else
      {
        $this->formId = 0;
      }
      if (isset($config['id']))
      {
        $this->id = $config['id'];
      }
      else
      {
        $this->id = 0;
      }

      if (isset($config['group_id']))
      {
        $this->group_id = $config['group_id'];
      }
      else
      {
        $this->group_id = 0;
      }

      if (isset($config['isGroup']))
      {
        $this->isGroup = $config['isGroup'];
      }
      else
      {
        $this->isGroup = false;
      }

      if (isset($config['group_type']))
      {
        $this->group_type = $config['group_type'];
      }
      else
      {
        $this->group_type = -1;
      }

      if (isset($config['inputGroupItem']))
      {
        $this->inputGroupItem = $config['inputGroupItem'];
      }
      else
      {
        $this->inputGroupItem = null;
      }

      if (isset($config['sets']))
      {
        $this->sets = $config['sets'];
      }


      if (isset($config['item_type']))
      {
        $this->item_type = $config['item_type'];
      }
      else
      {
        $this->item_type = 0;
      }
      if (isset($config['items']))
      {
        $this->items = $config['items'];
      }
      else
      {
        $this->items = [];
      }
      if (isset($config['column']))
      {
        $this->column = $config['column'];
      }
      else
      {
        $this->column = 12;
      }
      if (isset($config['gutterX']))
      {
        $this->gutterX = $config['gutterX'];
      }
      else
      {
        $this->gutterX = -1;
      }
      if (isset($config['gutterY']))
      {
        $this->gutterY = $config['gutterY'];
      }
      else
      {
        $this->gutterY = -1;
      }
      if (isset($config['content']))
      {
        $this->content = $config['content'];
      }
      $settings = FormeaGeneralHelper::getGeneralElementSettings();
      if (isset($config['settings']))
      {

        if (is_string($config['settings']))
        {
          $settings = json_decode($config['settings']);
        }
        else
        {
          $settings = $config['settings'];
        }

      }
      $settings = new Registry($settings);
      if (!$settingRegistry)
      {
        $settings = $settings->toArray();
      }
      $this->settings = $settings;

      if (isset($config['nextColumnIdx']))
      {
        $this->nextColumnIdx = $config['nextColumnIdx'];
      }
      if (isset($config['class']))
      {
        $this->class = $config['class'];
      }
      if (isset($config['styleSheet']))
      {
        $this->styleSheet = $config['styleSheet'];
      }
      else
      {
        $this->styleSheet = '';
      }
      if (isset($config['active']))
      {
        $this->active = $config['active'];
      }

      if ($this->id > 0 && empty($this->styleSheet) && $settingRegistry)
      {
        $this->_processStyleSheet();
      }

    }

    private function _processStyleSheet()
    {

      if (!empty($this->settings))
      {
        $settings = $this->settings;
        if (is_array($settings))
        {
          $settings = new Registry($settings);
        }
        $styleSheetParams = FormeaGeneralHelper::getStyleSheetParams();

        $elemType = 'row_' . $this->formId . '_' . $this->id;
        $table    = '#__formea_form_rows';
        if ($this->item_type == 1)
        {
          $elemType = 'column_' . $this->formId . '_' . $this->id;
          $table    = '#__formea_form_columns';
        }
        elseif ($this->item_type == 2)
        {
          $elemType = 'element_' . $this->formId . '_' . $this->content->element_id;
          $table    = '#__formea_form_elements';
        }

        $elemSelector = '.fm_' . $elemType . '_' . $this->id;
        $st           = $elemSelector . '{';
        $hasRowStyle  = false;

        foreach ($styleSheetParams as $target => $props)
        {
          $val = $settings->get($target);
          if (!empty($val))
          {
            $hasRowStyle = true;
            foreach ($props as $param)
            {
              $st .= $param . ':' . $val . ';';
            }
          }
        }
        $st .= '}';


        if ($hasRowStyle)
        {
          $this->styleSheet = $st;
          $upd              = new stdClass();
          $upd->id          = $this->id;
          $upd->styleSheet  = $st;
          $container        = Factory::getContainer();
          /** @var DatabaseDriver $db */
          $db = $container->get('DatabaseDriver');
          $db->updateObject($table, $upd, 'id');
        }
      }


    }

  }
