<?php

	/**
	 * @package     Joomla.Site
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	namespace Joomla\Component\Formea\Site\Model;

	defined('_JEXEC') or die;

	use Exception;
	use Feseur\Library\FsrResponse;
	use Joomla\CMS\Factory;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
	use Joomla\CMS\MVC\Model\BaseModel;
	use Joomla\Component\Formea\Site\Libraries\FormeaForm;
	use Joomla\Registry\Registry;
	use Joomla\Session\SessionInterface;

	/**
	 * Formea model for the Joomla Formea component.
	 *
	 * @since  1.0.0
	 */
	class GroupedelementModel extends BaseModel
	{
		/**
		 * @var string item
		 */
		protected $_item = null;


		public function __construct($config = [], MVCFactoryInterface $factory = null)
		{
			parent::__construct($config, $factory);
		}


		/**
		 *
		 * @return FsrResponse
		 *
		 * @throws Exception
		 * @since 1.0.0
		 */
		public function getElementGroup()
		{
			$app          = Factory::getApplication();
			$input        = $app->getInput();
			$form_id      = $input->getInt('form_id');
			$group_id     = $input->getInt('group_id');
			$setIndex     = $input->getInt('setIndex', 2);
			$uniqueString = $input->getString('fomtoken');
			$formeaForm   = new FormeaForm([
				'id'           => $form_id,
				'uniqueString' => $uniqueString
			]);
			$render       = $formeaForm->getGroupElement($group_id, $setIndex);

			return $render;
		}
	}
