<?php
	/**
	 * @package     Joomla.Site
	 * @subpackage  com_formea
	 *
	 * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.2.2
	 */

	namespace Joomla\Component\Formea\Site\View\Validateform;

	defined('_JEXEC') or die;

	use Feseur\Library\FsrResponse;
	use Joomla\CMS\Factory;
	use Joomla\CMS\MVC\View\JsonView as BaseHtmlView;
	use Joomla\CMS\Response\JsonResponse;


	/**
	 * HTML Formea View class for the Formea component
	 *
	 * @since  1.0.0
	 */
	class JsonView extends BaseHtmlView
	{
		public $retObject;

		public function display($tpl = null)
		{
			$app = Factory::getApplication();
			if (empty($this->retObject))
			{
				$this->retObject = new FsrResponse();
			}

			$msg           = '';
			$totalMessages = count($this->retObject->msg);
			for ($i = 0; $i < $totalMessages; $i++)
			{
				if ($i == 0)
				{
					$msg = $this->retObject->msg[$i]->text;
				}
				$app->enqueueMessage($this->retObject->msg[$i]->text, $this->retObject->msg[$i]->type);
			}
			echo new JsonResponse($this->retObject->result, $msg, !$this->retObject->success);
		}
	}
