<?php
  /**
   * @package     Joomla.Site
   * @subpackage  com_formea
   *
   * @copyright   Copyright (C) 2010-2024 Feseur Sdn Bhd. All rights reserved.
   * @license     GNU General Public License version 2 or later; see LICENSE.txt
   * @version     1.2.2
   */


  defined('_JEXEC') or die;

  use Joomla\CMS\HTML\HTMLHelper;
  use Joomla\CMS\Uri\Uri;
  use Joomla\Component\Formea\Site\Libraries\FormeaForm;


  /** @var $formObject */
  /** @var FormeaForm $formClass */
  /** @var $submissionData */
  $uniqueString = $formClass->getUniqueString();
  $formeaToken  = base64_encode($uniqueString);
  $item         = $formObject;

  $hiddenClass = '';
  if(!empty($submissionData)){
    if($submissionData->submissionMsgs->message_type === 'html'){ ?>
      <div style="display: block;margin:15px 0;">
      <?php if($submissionData->hasError){
        echo $submissionData->submissionMsgs->global_error_msg;
      }else{
        echo $submissionData->submissionMsgs->submission_msg;
      }?>
</div>
    <?php }
     if($submissionData->afterSubmission === 'hide'){
       $hiddenClass = 'formea-hidden';
     }
  }

?>
<?php if ((int) $item->allow_submission > 0): ?>
<form action="<?php echo Uri::current() ?>" enctype="multipart/form-data"
      id="formea_form_<?php echo $uniqueString; ?>"
      class="formea-form <?php echo $item->params->get('form_class', null); echo $hiddenClass; ?>"
  <?php echo $item->params->get('form_attributes', null); ?> method="post">
  <?php else: ?>
  <div id="formea_form_<?php echo $uniqueString; ?>"
       class="formea-form <?php echo $item->params->get('form_class', null); echo $hiddenClass; ?>"
       <?php echo $item->params->get('form_attributes', null); ?>>
    <?php endif; ?>


    <?php if (!empty($item->details->get('form_heading'))): ?>
      <h5><?php echo $item->details->get('form_heading'); ?></h5>
    <?php endif; ?>
    <?php
      echo $formClass->renderForm($item->elementLayouts);
    ?>
    <?php echo $item->honeypot; ?>
  <input type="hidden" name="fom" value="<?php echo $item->id; ?>">
    <?php if ((int) $item->allow_submission > 0): ?>
  <input type="hidden" name="return_url" value="<?php echo base64_encode(Uri::current()); ?>">
  <input type="hidden" name="fomToken" value="<?php echo $formeaToken; ?>">
  <input type="hidden" name="option" value="com_formea">
  <input type="hidden" name="task" value="formea.submit">
  <?php echo HTMLHelper::_('form.token'); ?>
</form>
    <?php else: ?>
  </div>
<?php endif; ?>


