<?php
    /**
     * @package    formea
     *
     * @author     Feseur Sdn Bhd
     * @copyright  Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
     * @license    GNU General Public License version 2 or later; see LICENSE.txt
     * @link       https://feseur.com
     * @version    1.0.6
     */

    defined('_JEXEC') or die;

    use Joomla\CMS\Application\CMSApplication;
    use Joomla\CMS\Log\Log;
    use Joomla\CMS\Plugin\CMSPlugin;
    use Joomla\CMS\WebAsset\WebAssetManager;
    use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;

    /**
     * Formea plugin.
     *
     * @package   formea
     * @since     1.0.0
     */
    class plgSystemFormea extends CMSPlugin
    {
        /**
         * Application object
         *
         * @var    CMSApplication
         * @since  1.0.0
         */
        protected $app;

        /**
         * Database object
         *
         * @var    JDatabaseDriver
         * @since  1.0.0
         */
        protected $db;

        /**
         * Affects constructor behavior. If true, language files will be loaded automatically.
         *
         * @var    boolean
         * @since  1.0.0
         */
        protected $autoloadLanguage = true;

        protected $renderedContent = [];

        /**
         * @var bool
         * @since 1.1.1
         */
        protected $hasModalSlide = false;

        /**
         * @var \Joomla\Component\Formea\Site\Libraries\FormeaCore | null
         * @since 1.1.1
         */
        protected $modalSlide = null;

        public function __construct(&$subject, $config = array())
        {
            if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_formea/src/Extension/FormeaComponent.php')) {
                return;
            }

            // Added on version 1.1.1
            if (file_exists(JPATH_ROOT . '/components/com_formea/plugins/core/ModalSlide/FormeaModalSlide.php')) {
                $this->hasModalSlide = true;
            }

            parent::__construct($subject, $config);
        }

        public function onAfterInitialise()
        {
            $componentName = 'com_formea';
            Log::addLogger(['text_file' => $componentName . '.log.php'], Log::ALL, [$componentName]);
        }

        /**
         * onBeforeCompileHead
         *
         * @since 1.0.0
         */
        public function onBeforeCompileHead()
        {
            $app = $this->app;
            if ($app->isClient('administrator')) {
                /** @var WebAssetManager $wa */
                $wa = $app->getDocument()->getWebAssetManager();
                try {
                    $wa->useScript('com_formea.inlinesvg');
                    $wa->useScript('com_formea.admin-core');
                } catch (Exception $e) {
                    $wa->registerAndUseScript('com_formea.inlinesvg', 'media/com_formea/js/inlinesvg.min.js');
                    $wa->registerAndUseScript('formea-admin-core', 'media/com_formea/js/admin-core.js');
                }
            } else {
                $document = $app->getDocument();
                if ($document->getType() !== 'html') {
                    return;
                }

                $option = $app->getInput()->get('option');
                $task = $app->getInput()->get('task');
                if ($option == 'com_content' && $task == 'edit') {
                    return;
                }

                $buffer = $app->getDocument()->getBuffer();
                $bufferJson = json_encode($buffer);
                /* if (strpos($bufferJson, '[formea id=') === false)
                 {
                    return;
                 }*/

                if (!strpos($bufferJson, '[formea id=') !== false) {
                    if ($this->hasModalSlide && !strpos($bufferJson, '[formea_ms=') !== false) {
                        return;
                    } elseif (!$this->hasModalSlide) {
                        return;
                    }
                }

                $pattern = '/\[formea id=\s*(\d+)\s*]/';
                if (preg_match_all($pattern, $bufferJson, $matches)) {
                    $numbers = $matches[1];
                    if (!empty($numbers)) {
                        $totalNumbers = count($numbers);
                        for ($j = 0; $j < $totalNumbers; $j++) {
                            $formId = $numbers[$j];
                            if (is_numeric($formId)) {
                                $formId = (int)$formId;
                                if ($formId > 0) {
                                    foreach ($matches[0] as $i => $match) {
                                        $rendered = FormeaGeneralHelper::renderForm($formId, true);
                                        if (!$rendered->success) {
                                            if (isset($rendered->msg[0])) {
                                                $this->app->enqueueMessage($rendered->msg[0]->text, $rendered->msg[0]->type);
                                            }
                                        } else {
                                            $this->renderedContent[$formId] = $rendered->result['content'];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                if ($this->hasModalSlide) {
                    $pattern = '/\[formea_ms=\s*(\d+)\s*]/';
                    if (preg_match_all($pattern, $bufferJson, $matches)) {
                        $numbers = $matches[1];
                        if (!empty($numbers)) {
                            $totalNumbers = count($numbers);
                            for ($j = 0; $j < $totalNumbers; $j++) {
                                $modalSlideId = $numbers[$j];
                                if (is_numeric($modalSlideId)) {
                                    $modalSlideId = (int)$modalSlideId;
                                    /** @var FormeaModalSlide $modalSlideClass */
                                    $modalSlideClass = $this->_getModalSlide();
                                    if ($modalSlideId > 0 && !empty($modalSlideClass)) {
                                        foreach ($matches[0] as $i => $match) {
                                            $rendered = $modalSlideClass->renderButton($modalSlideId);
                                            if (!$rendered->success) {
                                                if (isset($rendered->msg[0])) {
                                                    $this->app->enqueueMessage($rendered->msg[0]->text, $rendered->msg[0]->type);
                                                }
                                            } else {
                                                $this->renderedContent['ms_' . $modalSlideId] = $rendered->result['content'];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public function onAfterRender()
        {
            $app = $this->app;


            if ($app->isClient('administrator')) {
                return false;
            }

            $docType = $app->getDocument()->getType();
            if ($docType != 'html') {
                return false;
            }

            $option = $app->input->get('option');
            $task = $app->input->get('task');
            if ($option == 'com_content' && $task == 'edit') {
                return false;
            }

            $html = $app->getBody();

            if (strpos($html, '</head>') !== false) {
                list($head, $content) = explode('</head>', $html, 2);
            } else {
                $content = $html;
            }

            if (empty($content)) {
                return false;
            }
            $contentChanged = false;

            if (strpos($content, '[formea id=') !== false) {
                //expression to search for
                //$pattern = '/\[formea]\s*(\d+)\s*\[\/formea]/';
                $pattern = '/\[formea id=\s*(\d+)\s*]/';
                if (preg_match_all($pattern, $content, $matches)) {
                    $numbers = $matches[1];
                    if (!empty($numbers)) {
                        $totalNumbers = count($numbers);
                        for ($j = 0; $j < $totalNumbers; $j++) {
                            $formId = $numbers[$j];
                            if (isset($this->renderedContent[$formId])) {
                                if (isset($matches[0][$j])) {
                                    $match = $matches[0][$j];
                                    $tmp = explode($match, $content, 2);
                                    $before = strtolower(reset($tmp));
                                    $before = preg_replace('#\s+#', ' ', $before);
                                    if (strpos($before, '<textarea') !== false) {
                                        // find last occurrence
                                        $tmp = explode('<textarea', $before);
                                        $textarea = end($tmp);
                                        // found & no closing tag
                                        if (!empty($textarea) && strpos($textarea, '</textarea>') === false)
                                            continue;
                                    }
                                    $_form = $this->renderedContent[$formId];
                                    $content = str_replace($match, $_form, $content);
                                }
                            }
                        }

                        $html = isset($head) ? ($head . '</head>' . $content) : $content;
                        $contentChanged = true;
                        //$app->setBody($html);
                    }
                }
            }

            if (strpos($content, '[formea_ms=') !== false && $this->hasModalSlide) {
                $pattern = '/\[formea_ms=\s*(\d+)\s*]/';
                if (preg_match_all($pattern, $content, $matches)) {
                    $numbers = $matches[1];
                    if (!empty($numbers)) {

                        $totalNumbers = count($numbers);
                        for ($j = 0; $j < $totalNumbers; $j++) {
                            $modalSlideItemId = $numbers[$j];
                            if (isset($this->renderedContent['ms_' . $modalSlideItemId])) {
                                if (isset($matches[0][$j])) {
                                    $match = $matches[0][$j];
                                    $tmp = explode($match, $content, 2);
                                    $before = strtolower(reset($tmp));
                                    $before = preg_replace('#\s+#', ' ', $before);
                                    if (strpos($before, '<textarea') !== false) {
                                        // find last occurrence
                                        $tmp = explode('<textarea', $before);
                                        $textarea = end($tmp);
                                        // found & no closing tag
                                        if (!empty($textarea) && strpos($textarea, '</textarea>') === false)
                                            continue;
                                    }
                                    $_form = $this->renderedContent['ms_' . $modalSlideItemId]['button'];
                                    $_panel = $this->renderedContent['ms_' . $modalSlideItemId]['panel'] . '</body>';
                                    $content = str_replace($match, $_form, $content);
                                    $content = str_replace('</body>', $_panel, $content);
                                }
                            }
                        }

                        $html = isset($head) ? ($head . '</head>' . $content) : $content;
                        $contentChanged = true;
                    }
                }
            }

            if ($contentChanged) {
                $app->setBody($html);
            }


            return true;
        }

        /**
         * Method to run the Modal/Slide script before compiling head
         *
         * @since 1.1.1
         */
        protected function _getModalSlide()
        {
            if ($this->hasModalSlide && empty($this->modalSlide)) {
                require_once JPATH_ROOT . '/components/com_formea/plugins/core/ModalSlide/FormeaModalSlide.php';
                $this->modalSlide = new FormeaModalSlide([]);
            }

            return $this->modalSlide;
        }
    }
