<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\Controller;

defined('_JEXEC') or die;

use Exception;
use Feseur\Library\FsrResponse;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Joomla\Component\Formea\Administrator\Model\ValidationModel;
use Joomla\Filesystem\Path;

/**
 * Controller for a single formea
 *
 * @since  1.0
 */
class EltypeController extends FormController
{
  /**
   * The prefix to use with controller messages.
   *
   * @var    string
   * @since  1.0.0
   */
  protected $text_prefix = 'COM_FORMEA';

  public function save($key = null, $urlVar = null)
  {
    $saved = parent::save($key, $urlVar); // TODO: Change the autogenerated stub

  }

  /**
   * Method to run batch operations.
   *
   * @param   object  $model  The model.
   *
   * @return  boolean   True if successful, false otherwise and internal error is set.
   *
   * @since   1.0
   */
  public function batch($model = null)
  {
    $this->checkToken();

    $model = $this->getModel('Eltype', 'Administrator', array());

    // Preset the redirect
    $this->setRedirect(Route::_('index.php?option=com_formea&view=validations' . $this->getRedirectToListAppend(), false));

    return parent::batch($model);
  }

  /**
   * Install an element plugin
   */
  public function install()
  {
    $this->checkToken();
    $app    = Factory::getApplication();
    $plugin = $app->getInput()->files->getRaw('plugin_package', []);

    /** @var ValidationModel $model */
    $model = $this->getModel('eltype');

    try {
      if (empty($plugin)) {
        throw new Exception(Text::_('COM_FORMEA_NOT_FILE_UPLOADED'));
      }
      $model->install($plugin);
      $this->setRedirect(Route::_('index.php?option=com_formea&view=eltypes', false), Text::_('COM_FORMEA_ELTYPE_PLUGIN_INSTALLED'));
    } catch (Exception $e) {
      $this->app->enqueueMessage($e->getMessage(), 'error');
      $this->setRedirect(Route::_('index.php?option=com_formea&view=eltypes', false), Text::_('COM_FORMEA_ELTYPE_PLUGIN_INSTALL_ERROR'));
    }
  }


  /**
   *
   * @return false|string|void
   *
   * @since 1.0.6
   */
  public function apiCall()
  {

    $retObject = new FsrResponse();
    $app = Factory::getApplication();
    try {
      $mode = $this->input->get('formeaMode');
      if ($mode !== 'debug') {
        if (!$this->checkToken('GET')) {
          throw new Exception('Invalid token');
        }
      } else {
        if (!defined('FORMEA_PLG_PATH')) {
          define('FORMEA_PLG_PATH', JPATH_ROOT . '/components/com_formea/plugins');
          define('FORMEA_CORE_PATH', FORMEA_PLG_PATH . '/core');
          define('FORMEA_THEME_PATH', FORMEA_PLG_PATH . '/theme');
          define('FORMEA_ELEMENT_PATH', FORMEA_PLG_PATH . '/element');
          define('FORMEA_VALIDATION_PATH', FORMEA_PLG_PATH . '/validation');
        }
      }
      $methodName    = $app->getInput()->getString('methodName');
      $extensionName = $app->getInput()->getString('extensionName');
      $config        = $app->getInput()->getString('config', [], 'ARRAY');
      $args          = $app->getInput()->get('args', [], 'RAW');

      $clsName       = 'Formea' . $extensionName;
      $targetFile    = $clsName . '.php';
      if (!is_file(Path::clean(FORMEA_ELEMENT_PATH . '/' . $extensionName . '/' . $targetFile))) {
        throw new Exception('Invalid Element type');
      }
      require_once FORMEA_ELEMENT_PATH . '/' . $extensionName . '/' . $targetFile;
      if (!class_exists($clsName) || !method_exists($clsName, $methodName)) {
        throw new Exception('Invalid method');
      }
      $class  = new $clsName($config);
      $result = $class->{$methodName}($args);

      $retObject->setResult($result);
      $retObject->setSuccess(true);
    } catch (Exception $e) {
      $retObject->setSuccess(false);
      $retObject->setMsg($e->getMessage());
    }

    if ($mode !== 'debug') {
      echo json_encode($retObject);
      $this->app->close();
    } else {
      return json_encode($retObject);
    }
  }
}
