<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @since       1.2.1
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\EditorField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;

class FormeaLangEditorField extends EditorField
{
  /**
   * The name field type.
   *
   * @var    string
   */
  public $type = 'FormeaLangEditor';

  private $languages = [];
  private $langTag = 'en_GB';
  private $app;

  public function __construct($form = null)
  {
    parent::__construct($form);
    $this->app = Factory::getApplication();
    $this->languages = FormeaGeneralHelper::getLanguages();
    $langTag = $this->app->getLanguage()->getTag();
    $this->langTag = str_replace('-', '_', $langTag);
    if (count($this->languages) > 1) {
      /** @var WebAssetManager $wa */
      $wa = $this->app->getDocument()->getWebAssetManager();
      $wa->useStyle('webcomponent.joomla-tab');
      $wa->useScript('webcomponent.joomla-tab');
    }
  }

  /**
   * Method to get the field input markup for the editor area
   *
   * @return  string  The field input markup.
   *
   * @since   1.6
   */
  protected function getInput()
  {
    // Get an editor object.
    $editor = $this->getEditor();
    $params = [
      'autofocus' => $this->autofocus,
      'readonly'  => $this->readonly || $this->disabled,
      'syntax'    => (string) $this->element['syntax'],
    ];
    $html = '';

    $totalLanguages = count($this->languages);
    if ($totalLanguages > 1) {
      $tabSetName = $this->name . 'tabset';
      $html .= HTMLHelper::_('uitab.startTabSet', $tabSetName, array('active' => $this->langTag));

      for ($i = 0; $i < $totalLanguages; $i++) {
        $langCode = str_replace('-', '_', $this->languages[$i]->lang_code);

        $name = $this->name . '[' . $langCode . ']';
        $id = $this->id . '_' . $langCode;
        $value = "";
        if (isset($this->value->{$langCode})) {
          $value = $this->value->{$langCode};
        }
        $html .= HTMLHelper::_('uitab.addTab', $tabSetName, $langCode, $this->languages[$i]->title);
        $html .= $editor->display(
          $name,
          htmlspecialchars($value, ENT_COMPAT, 'UTF-8'),
          $this->width,
          $this->height,
          $this->columns,
          $this->rows,
          $this->buttons ? (\is_array($this->buttons) ? array_merge($this->buttons, $this->hide) : $this->hide) : false,
          $id,
          $this->asset,
          $this->form->getValue($this->authorField),
          $params
        );
        $html .= HTMLHelper::_('uitab.endTab');
      }

      $html .= HTMLHelper::_('uitab.endTabSet');
    } else {
      $name = $this->name . '[' . $this->langTag . ']';
      $id = $this->id . '_' . $this->langTag;
      $value = "";
      if (isset($this->value->{$this->langTag})) {
        $value = $this->value->{$this->langTag};
      }
      $html .= $editor->display(
        $name,
        htmlspecialchars($value, ENT_COMPAT, 'UTF-8'),
        $this->width,
        $this->height,
        $this->columns,
        $this->rows,
        $this->buttons ? (\is_array($this->buttons) ? array_merge($this->buttons, $this->hide) : $this->hide) : false,
        $id,
        $this->asset,
        $this->form->getValue($this->authorField),
        $params
      );
    }
    return $html;
  }
}
