<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\Component\Formea\Administrator\View\Formeas\HtmlView;

/** @var HtmlView $this */

$user      = Factory::getApplication()->getIdentity();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$saveOrder = $listOrder === 'a.ordering';

if ($saveOrder && !empty($this->items)) {
  $saveOrderingUrl = 'index.php?option=com_formea&task=coreextensions.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
  HTMLHelper::_('draggablelist.draggable');
}
?>
<form action="<?php echo Route::_('index.php?option=com_formea&view=coreextensions'); ?>" method="post"
  enctype="multipart/form-data"
  name="adminForm" id="adminForm">
  <div class="row">
    <div class="col-md-12">
      <div id="j-main-container" class="j-main-container">
        <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
        <?php if (empty($this->items)) : ?>
          <div class="alert alert-warning">
            <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
          </div>
        <?php else : ?>
          <table class="table itemList" id="formeaList">
            <caption class="visually-hidden">
              <?php echo Text::_('COM_FORMEA_TABLE_CAPTION'); ?>,
              <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
              <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
            </caption>
            <thead>
              <tr>
                <td class="w-1 text-center">
                  <?php echo HTMLHelper::_('grid.checkall'); ?>
                </td>

                <th scope="col" class="w-1 text-center">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" style="min-width:100px">
                  <?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_TABLE_TABLEHEAD_NAME', 'a.title', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" style="min-width:100px">
                  <?php echo Text::_('COM_FORMEA_DESCRIPTION'); ?>
                </th>
                <th scope="col" class="w-10 d-none d-lg-table-cell">
                  <?php echo Text::_('COM_FORMEA_VERSION'); ?>
                </th>
                <th scope="col" class="w-3 d-none d-lg-table-cell">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
              </tr>
            </thead>
            <tbody>
              <?php
              foreach ($this->items as $i => $item) :
                $canEdit = $user->authorise('core.edit', 'com_formea.coreextension.' . $item->id);
                $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || is_null($item->checked_out);
                $canEditOwn = $user->authorise('core.edit.own', 'com_formea.coreextension.' . $item->id) && $item->created_by == $userId;
                $canChange = $user->authorise('core.edit.state', 'com_formea.coreextension.' . $item->id) && $canCheckin;
                $totalDependableElements = count($item->dependable_forms);
              ?>
                <tr class="row<?php echo $i % 2; ?>">
                  <td class="text-center">
                    <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                  </td>
                  <td class="text-center object-status">
                    <?php echo HTMLHelper::_('jgrid.published', $item->state, $i, 'coreextensions.', $canChange, 'cb', $item->publish_up, $item->publish_down); ?>
                  </td>
                  <th scope="row" class="has-context">
                    <?php if ($item->checked_out) : ?>
                      <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'coreextensions.', $canCheckin); ?>
                    <?php endif; ?>
                    <?php $editIcon = '<span class="fa fa-pencil-square me-2" aria-hidden="true"></span>'; ?>
                    <a class="hasTooltip"
                      href="<?php echo Route::_('index.php?option=com_formea&task=coreextension.edit&id=' . (int) $item->id); ?>"
                      title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape(addslashes($item->title)); ?>">
                      <?php echo $editIcon; ?><?php echo $this->escape($item->title); ?></a>
                    <?php if ($item->state != 1 && $totalDependableElements > 0) {
                      $elements = [];
                      for ($j = 0; $j < $totalDependableElements; $j++) {
                        $elements[] = $item->dependable_forms[$j]->element_title;
                      }
                    ?>
                      <br><small class="text-danger fw-normal">
                        <?php echo Text::sprintf('COM_FORMEA_S_ELEMENTS_DEPENDING_ON_VALIDATION', implode(', ', $elements)); ?>
                      </small>
                    <?php }
                    ?>

                  </th>
                  <td scope="row" class="has-context small">
                    <?php echo Text::_($item->description); ?>
                  </td>
                  <td class="d-none d-md-table-cell">
                    <?php echo $item->version; ?>
                  </td>
                  <td class="d-none d-md-table-cell">
                    <?php echo $item->id; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>

          <?php echo $this->pagination->getListFooter(); ?>


        <?php endif; ?>
        <?php echo HTMLHelper::_(
          'bootstrap.renderModal',
          'coreInstallModal',
          [
            'title'  => Text::_('COM_FORMEA_CORE_INSTALL_NEW'),
            'footer' => $this->loadTemplate('install_footer'),
          ],
          $this->loadTemplate('install_body')
        ); ?>
        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
      </div>
    </div>
  </div>
</form>
<?php echo $this->loadTemplate('js'); ?>