<?php

	/**
	 * @package         Joomla.Administrator
	 * @subpackage      com_formea
	 *
	 * @copyright       Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
	 * @license         GNU General Public License version 2 or later; see LICENSE.txt
	 */

	defined('_JEXEC') or die;

	use Joomla\CMS\Factory;
	use Joomla\CMS\HTML\HTMLHelper;
	use Joomla\CMS\Language\Text;
	use Joomla\CMS\Layout\LayoutHelper;
	use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;

	$displayData = [
		'textPrefix' => 'COM_FORMEA_CORES',
		'formURL'    => 'index.php?option=com_formea&view=coreextensions',
		'helpURL'    => FormeaHelper::getHelpLink('Cores'),
		'icon'       => 'icon-code-branch',
		'formAppend' => HTMLHelper::_(
			'bootstrap.renderModal',
			'coreInstallModal',
			[
				'title'  => Text::_('COM_FORMEA_INSTALL_NEW_CORE'),
				'footer' => $this->loadTemplate('install_footer'),
			],
			$this->loadTemplate('install_body')
		)
	];

	$user = Factory::getApplication()->getIdentity();
	echo LayoutHelper::render('joomla.content.emptystate', $displayData);
	echo $this->loadTemplate('js');
