<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\Formea\Administrator\View\Formea\HtmlView;
use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;

/** @var HtmlView $this */
$totalLang        = count($this->languageLists);
$lTag             = str_replace('-', '_', $this->lang_tag);
$totalPlaceholder = count($this->placeholder_keys);

?>

<div class="row">
  <div class="col-md-9">
    <?php
    echo HTMLHelper::_('uitab.startTabSet', 'submissionEmailTab', array('active' => 'adminemail'));
    echo HTMLHelper::_('uitab.addTab', 'submissionEmailTab', 'adminemail', Text::_('COM_FORMEA_ADMIN_EMAIL'));
    ?>
    <div class="d-block p-3">
      <fieldset class="options-form ">
        <legend><?php echo Text::_('COM_FORMEA_ADMIN_EMAIL_ADDRESSES'); ?></legend>
        <div class="form-grid">
          <div class="row mb-3">
            <div class="col-md-4">
              <?php echo $this->form->renderField('from_email', 'emails.admin', null, ['class' => 'control-label-sm']); ?>
            </div>
            <div class="col-md-4">
              <?php echo $this->form->renderField('to_email', 'emails.admin', null, ['class' => 'control-label-sm']); ?>
            </div>
            <div class="col-md-4">
              <?php echo $this->form->renderField('replyto_email', 'emails.admin', null, ['class' => 'control-label-sm']); ?>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <?php echo $this->form->renderField('cc_email', 'emails.admin', null, ['class' => 'control-label-sm']); ?>
            </div>
            <div class="col-md-6">
              <?php echo $this->form->renderField('bcc_email', 'emails.admin', null, ['class' => 'control-label-sm']); ?>
            </div>
          </div>
        </div>
      </fieldset>

      <fieldset class="options-form formea-imitate-tab">
        <legend><?php echo Text::_('COM_FORMEA_ADMIN_EMAIL_CONTENT'); ?></legend>
        <?php
        if ($this->isMultiLang && $totalLang > 1) {
          echo HTMLHelper::_('uitab.startTabSet', 'langTabAdminEmail', array('active' => $lTag . 'admin_email_content', 'orientation' => 'horizontal'));
          for ($i = 0; $i < $totalLang; $i++) {
            $ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
            echo HTMLHelper::_('uitab.addTab', 'langTabAdminEmail', $ltag . 'admin_email_content', $this->languageLists[$i]->title);
        ?>
            <div class="form-grid p-3">
              <?php
              echo $this->form->renderField('from_name', 'emails.admin.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('replyto_name', 'emails.admin.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('subject', 'emails.admin.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('email_content', 'emails.admin.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('attachments', 'emails.admin.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              ?>
            </div>
          <?php
            echo HTMLHelper::_('uitab.endTab');
          }
          echo HTMLHelper::_('uitab.endTabSet');
        } else {
          ?>
          <div class="form-grid">
            <?php
            echo $this->form->renderField('from_name', 'emails.admin.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('replyto_name', 'emails.admin.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('subject', 'emails.admin.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('email_content', 'emails.admin.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('attachments', 'emails.admin.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            ?>
          </div>
        <?php
        }
        ?>
      </fieldset>
    </div>

    <?php

    echo HTMLHelper::_('uitab.endTab');
    echo HTMLHelper::_('uitab.addTab', 'submissionEmailTab', 'useremail', Text::_('COM_FORMEA_USER_EMAIL'));
    ?>
    <div class="d-block p-3">
      <fieldset class="options-form ">
        <legend><?php echo Text::_('COM_FORMEA_USER_EMAIL_ADDRESSES'); ?></legend>
        <div class="form-grid">
          <div class="row mb-3">
            <div class="col-md-4">
              <?php echo $this->form->renderField('from_email', 'emails.user', null, ['class' => 'control-label-sm']); ?>
            </div>
            <div class="col-md-4">
              <?php echo $this->form->renderField('to_email', 'emails.user', null, ['class' => 'control-label-sm']); ?>
            </div>
            <div class="col-md-4">
              <?php echo $this->form->renderField('replyto_email', 'emails.user', null, ['class' => 'control-label-sm']); ?>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <?php echo $this->form->renderField('cc_email', 'emails.user', null, ['class' => 'control-label-sm']); ?>
            </div>
            <div class="col-md-6">
              <?php echo $this->form->renderField('bcc_email', 'emails.user', null, ['class' => 'control-label-sm']); ?>
            </div>
          </div>
        </div>
      </fieldset>
      <fieldset class="options-form formea-imitate-tab">
        <legend><?php echo Text::_('COM_FORMEA_USER_EMAIL_CONTENT'); ?></legend>
        <?php
        if ($this->isMultiLang && $totalLang > 1) {
          echo HTMLHelper::_('uitab.startTabSet', 'langTabAdminEmail', array('active' => $lTag . 'user_email_content', 'orientation' => 'horizontal'));
          for ($i = 0; $i < $totalLang; $i++) {
            $ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
            echo HTMLHelper::_('uitab.addTab', 'langTabAdminEmail', $ltag . 'user_email_content', $this->languageLists[$i]->title);
        ?>
            <div class="form-grid p-3">
              <?php
              echo $this->form->renderField('from_name', 'emails.user.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('replyto_name', 'emails.user.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('subject', 'emails.user.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('email_content', 'emails.user.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              echo $this->form->renderField('attachments', 'emails.user.contents.' . $ltag, null, ['class' => 'control-label-sm']);
              ?>
            </div>
          <?php
            echo HTMLHelper::_('uitab.endTab');
          }
          echo HTMLHelper::_('uitab.endTabSet');
        } else {
          ?>
          <div class="form-grid">
            <?php
            echo $this->form->renderField('from_name', 'emails.user.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('replyto_name', 'emails.user.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('subject', 'emails.user.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('email_content', 'emails.user.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            echo $this->form->renderField('attachments', 'emails.user.contents.' . $lTag, null, ['class' => 'control-label-sm']);
            ?>
          </div>
        <?php
        }
        ?>
      </fieldset>
    </div>
    <?php
    echo HTMLHelper::_('uitab.endTab');
    echo HTMLHelper::_('uitab.endTabSet'); ?>
  </div>
  <div class="col-md-3 ps-0">
    <h5><?php echo Text::_('COM_FORMEA_AVAILABLE_PLACEHOLDERS'); ?></h5>
    <p class="m-0 text-muted"><?php echo Text::_('COM_FORMEA_GLOBAL'); ?></p>
    <ul class="list-unstyled placeholder-static-list">
      <?php
      for ($i = 0; $i < $totalPlaceholder; $i++) { ?>
        <li>
          <button type="button" onclick="FormeaCopyClipboard('[<?php echo $this->placeholder_keys[$i]; ?>]','placeholderClipboard');" title="<?php echo Text::_('COM_FORMEA_CLICK_COPY_CLIPBOARD') ?>">
            [<?php echo $this->placeholder_keys[$i]; ?>]
          </button>
        </li>
      <?php } ?>
    </ul>
    <p class="m-0 text-muted"><?php echo Text::_('COM_FORMEA_ELEMENTS'); ?></p>
    <ul class="list-unstyled placeholder-static-list" id="key_placeholders">

    </ul>
    <input type="hidden" id="placeholderClipboard" />
  </div>
</div>