<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\Formea\Administrator\View\Formea\HtmlView;

/** @var HtmlView $this */
$totalLang = count($this->languageLists);
$lTag      = str_replace('-', '_', $this->lang_tag);
?>
<div class="row">
	<div class="col-md-8">
		<?php


		if ($this->isMultiLang && $totalLang > 1) {
			echo HTMLHelper::_('uitab.startTabSet', 'langTab', array('active' => $lTag));
			for ($i = 0; $i < $totalLang; $i++) {
				$ltag = str_replace('-', '_', $this->languageLists[$i]->lang_code);
				echo HTMLHelper::_('uitab.addTab', 'langTab', $ltag, $this->languageLists[$i]->title);
		?>
				<div class="d-block p-3">
					<?php
					echo $this->form->renderField('form_heading', 'details.' . $ltag);
					// echo $this->form->renderField('submission_msg', 'details.' . $ltag);
					echo $this->form->renderField('metakey', 'details.' . $ltag);
					echo $this->form->renderField('metadesc', 'details.' . $ltag);
					?>
				</div>
		<?php
				echo HTMLHelper::_('uitab.endTab');
			}
			echo HTMLHelper::_('uitab.endTabSet');
		} else {
			echo $this->form->renderField('form_heading', 'details.' . $lTag);
			//echo $this->form->renderField('submission_msg', 'details.' . $lTag);
			echo $this->form->renderField('metakey', 'details.' . $lTag);
			echo $this->form->renderField('metadesc', 'details.' . $lTag);
		}

		?>
	</div>
	<div class="col-md-4">
		<?php echo $this->form->renderField('form_class', 'params'); ?>
		<?php echo $this->form->renderField('form_attributes', 'params'); ?>
	</div>
</div>