<?php
	/**
	 * @package     Joomla.Library
	 * @subpackage  Feseur Library
	 *
	 * @copyright   Copyright (C) 2010 - 2022 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.0.6
	 */

	namespace Feseur\Library;

	defined('_JEXEC') or die;

	use DateTimeZone;
	use Joomla\CMS\Date\Date;
	use Joomla\CMS\Factory;
	use Joomla\Database\DatabaseDriver;

	class FsrDate extends Date
	{

		/**
		 * @throws \Exception
		 */
		public function __construct($date = 'now', $tz = null)
		{
			$app    = Factory::getApplication();
			$config = $app->getConfig();
			$offset = $config->get('offset', null);
			if (!empty($offset))
			{
				$tz = new DateTimeZone($offset);
			}
			parent::__construct($date, $tz);
		}

		public function format($format, $local = false, $translate = true): string
		{
			return parent::format($format, $local, $translate);
		}

		public function toSql($local = true, DatabaseDriver $db = null)
		{
			return parent::toSql($local, $db);
		}
	}

