<?php
	/**
	 * @package     Joomla.Library
	 * @subpackage  Feseur Library
	 *
	 * @copyright   Copyright (C) 2010 - 2022 Feseur Sdn Bhd. All rights reserved.
	 * @license     GNU General Public License version 2 or later; see LICENSE.txt
	 * @version     1.0.6
	 */

	namespace Feseur\Library;

	defined('_JEXEC') or die;
	class FsrResponse
	{
		/**
		 * @var bool
		 * @since 1.0.0
		 */
		public $success = false;

		/**
		 * @var mixed|null
		 * @since 1.0.0
		 */
		public $result = null;

		/**
		 * @var FsrResponseMsg[]
		 * @since version 1.0.0
		 */
		public $msg;

		public function __construct($success = false, $result = null, $msg = array())
		{
			$this->success = $success;
			$this->result  = $result;
			$this->msg     = $msg;
		}

		public function setMsg($text = '', $type = 'danger', $show = true)
		{
			if (!empty($text))
			{
				$msg         = new FsrResponseMsg($text, $type, $show);
				$this->msg[] = $msg;
			}
		}

		public function setSuccess($success)
		{
			$this->success = $success;
		}

		public function setResult($result)
		{
			$this->result = $result;
		}

	}
