<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\Controller;

defined('_JEXEC') or die;

use Exception;
use Feseur\Library\FsrFieldQuery;
use Feseur\Library\FsrHelper;
use Feseur\Library\FsrResponse;
use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\CMS\HTML\Helpers\Access;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;
use Joomla\Component\Formea\Administrator\Model\ElementModel;
use Joomla\Component\Formea\Site\Helper\FormeaGeneralHelper;
use Joomla\Component\Formea\Site\Libraries\FormeaElement;
use Joomla\Component\Formea\Site\Libraries\FormeaEltypes;
use Joomla\Component\Formea\Site\Libraries\FormeaGridItem;
use Joomla\Component\Formea\Site\Libraries\FormeaGroupedElement;
use Joomla\Component\Formea\Site\Libraries\FormeaValidations;
use Joomla\Database\DatabaseDriver;
use Joomla\Filesystem\Path;
use Joomla\Registry\Registry;
use stdClass;

/**
 * Controller for a single element
 *
 * @since  1.0
 */
class GroupedelementController extends FormController
{

  /**
   * Method to get a model object, loading it if required.
   *
   * @param   string  $name    The model name. Optional.
   * @param   string  $prefix  The class prefix. Optional.
   * @param   array   $config  Configuration array for model. Optional.
   *
   * @return  BaseDatabaseModel  The model.
   *
   * @since   1.6
   */
  public function getModel($name = 'Groupedelement', $prefix = '', $config = array('ignore_request' => true))
  {
    return parent::getModel($name, $prefix, $config);
  }

  /**
   * The prefix to use with controller messages.
   *
   * @var    string
   * @since  1.0.0
   */
  protected $text_prefix = 'COM_FORMEA_GROUPED_ELEMENT';

  public function save($key = null, $urlVar = null)
  {
    $saved = parent::save($key, $urlVar); // TODO: Change the autogenerated stub

  }


  /**
   * Method to run batch operations.
   *
   * @param   object  $model  The model.
   *
   * @return  boolean   True if successful, false otherwise and internal error is set.
   *
   * @since   1.0
   */
  public function batch($model = null)
  {
    $this->checkToken();

    $model = $this->getModel('Groupedelement', 'Administrator', array());

    // Preset the redirect
    $this->setRedirect(Route::_('index.php?option=com_formea&view=groupedelements' . $this->getRedirectToListAppend(), false));

    return parent::batch($model);
  }


  public function initBuilder()
  {
    $retObject = new FsrResponse();
    $mode      = $this->input->get('formeaMode');
    try {
      if ($mode !== 'debug') {
        if (!$this->checkToken('GET')) {
          throw new Exception('Invalid token');
        }
      } else {
        if (!defined('FORMEA_PLG_PATH')) {
          define('FORMEA_PLG_PATH', JPATH_ROOT . '/components/com_formea/plugins');
          define('FORMEA_CORE_PATH', FORMEA_PLG_PATH . '/core');
          define('FORMEA_THEME_PATH', FORMEA_PLG_PATH . '/theme');
          define('FORMEA_ELEMENT_PATH', FORMEA_PLG_PATH . '/element');
          define('FORMEA_VALIDATION_PATH', FORMEA_PLG_PATH . '/validation');
        }
      }
      $form_id        = $this->app->getInput()->getInt('group_id', 0);
      $elementFilters = $this->app->getInput()->get('elementFilters', [], 'ARRAY');
      $onlyElements   = filter_var($this->app->getInput()->getInt('onlyElements', 0), FILTER_VALIDATE_BOOLEAN);

      if (!empty($elementFilters)) {
        if (isset($elementFilters['limit'])) {
          $elementFilters['limit']     = (int) $elementFilters['limit'];
          $elementFilters['offset']    = (int) $elementFilters['offset'];
          $elementFilters['eltype_id'] = (int) $elementFilters['eltype_id'];
        }
      }
      $elementFilters = new Registry($elementFilters);

      $langTag = $this->app->getLanguage()->getTag();

      /** @var FsrFieldQuery[] $whereClause */
      $groupWhereClause = [
        (object) ['field' => 'a.state', 'operator' => '=', 'value' => '1000']
        //(object) ['field' => 'a.group_type', 'operator' => '=', 'value' => '1']
      ];

      /** @var FsrFieldQuery[] $whereClause */
      $whereClause = [
        (object) ['field' => 'a.state', 'operator' => '=', 'value' => '1']
      ];

      if (!empty($elementFilters->get('search'))) {
        $whereClause[] = (object) ['field' => 'a.title', 'operator' => 'LIKE', 'value' => '%' . $elementFilters->get('search') . '%'];
      }
      if ($elementFilters->get('eltype_id', 0) > 0) {
        $whereClause[] = (object) ['field' => 'b.id', 'operator' => '=', 'value' => (string) $elementFilters->get('eltype_id')];
      }
      $commonElements = FormeaHelper::getCommonGridItems(
        true,
        $whereClause,
        $groupWhereClause,
        [
          'limit'  => $elementFilters->get('limit', 15),
          'offset' => $elementFilters->get('offset', 0)
        ],
        ['created_date' => 'DESC']
      );
      $elements       = $commonElements['items'];
      $pagination     = $commonElements['pagination'];
      $elementFilters->set('total', $pagination['total']);
      $elementFilters->set('currentPage', $pagination['page']);

      $groupType              = 0;
      $groupTypeOptions       = [];
      $langOptions            = [];
      $layoutTextString       = [];
      $elementTypes           = [];
      $batchColumnSetting     = [];
      $defaultGeneralSettings = [];
      $borderStyleOptions     = [];
      $styleSheetParams       = [];
      $columnOptions          = [];
      $gutterOptions          = [];
      $multiValSettingParams  = [];
      $stdColumnOption        = [];
      $limitFilterOptions     = [];
      $inputGroupItem         = [
        'class'         => '',
        'settings'      => '',
        'labelSettings' => '',
        'elements'      => [],
        'styleSheet'    => '',
        'igSetting'     => [
          'bare' => false
        ]
      ];
      $rows                   = [];
      if (!$onlyElements) {
        $app       = Factory::getApplication();
        $lang      = $app->getLanguage();
        $languages = FormeaGeneralHelper::getLanguages(true);

        $langData           = FormeaGeneralHelper::prepareLangData(true);
        $langTagUnderScore  = '';
        $langTitle          = '';
        $batchLabelSettings = [];
        foreach ($langData as $langTagUnderscore => $lang) {
          if (isset($languages[$langTagUnderscore])) {
            if (empty($langTagUnderScore) && empty($langTitle)) {
              $langTagUnderScore = $langTagUnderscore;
              $langTitle         = $languages[$langTagUnderscore]->title;
            }
            $langOptions[]              = (object) [
              'lang_code'  => $langTagUnderscore,
              'lang_title' => $languages[$langTagUnderscore]->title
            ];
            $batchLabelSetting          = FormeaGeneralHelper::getBlankLabelSetting($langTagUnderscore, $languages[$langTagUnderscore]->title);
            $batchLabelSetting->caption = Text::_('COM_FORMEA_DEFAULT_GROUP_LABEL');
            $batchLabelSettings[]       = $batchLabelSetting;
          }
        }
        //text string
        $layoutTextString = FsrHelper::getCommonLanguage(true, [
          JPATH_ROOT . '/administrator/components/com_formea/language/' . $langTag . '/com_formea.ini'
        ], $langTag);


        //element Types
        $formeaEltypes = new FormeaEltypes();
        $elTypes       = $formeaEltypes->get();
        $elementTypes  = [];
        if (!empty($elTypes)) {
          $totalElTypes = count($elTypes);
          for ($i = 0; $i < $totalElTypes; $i++) {

            $elTypeImageDetails = [
              'image'     => '',
              'imageSafe' => '',
              'imageType' => 0
            ];
            if (!empty($elTypes[$i]->imageDetails) && isset($elTypes[$i]->imageDetails['image'])) {
              if ($elTypes[$i]->imageDetails['imageType'] === 1) {
                if (is_file(Path::clean(JPATH_ROOT . '/' . $elTypes[$i]->imageDetails['image']))) {
                  $elTypeImageDetails['image'] = file_get_contents(JPATH_ROOT . '/' . $elTypes[$i]->imageDetails['image']);
                }
              } else {
                $elTypeImageDetails['image'] = Uri::base() . $elTypes[$i]->imageDetails['image'];
              }
              $elTypeImageDetails['imageType'] = $elTypes[$i]->imageDetails['imageType'];
            }

            $elementTypes[] = (object) [
              'id'           => $elTypes[$i]->id,
              'value_type'   => $elTypes[$i]->value_type,
              'name'         => $elTypes[$i]->name,
              'description'  => $elTypes[$i]->description,
              'title'        => $elTypes[$i]->title,
              'imageDetails' => $elTypeImageDetails,
            ];
          }
        }


        //DefaultGeneralSettings
        $defaultGeneralSettings          = FormeaGeneralHelper::getGeneralElementSettings();
        $styleSheetParams                = FormeaGeneralHelper::getStyleSheetParams();
        $inputGroupItem['settings']      = $defaultGeneralSettings;
        $inputGroupItem['labelSettings'] = $batchLabelSettings;
        $batchColumnSetting              = (object) [
          'labelSettings' => $batchLabelSettings,
          'column_class'  => '',
          'settings'      => $defaultGeneralSettings
        ];

        $groupType = 0;


        if ($form_id > 0) {
          $formeaGroupedElement = new FormeaGroupedElement($form_id, [
            'isPreview' => true
          ]);
          $formeaGroupedElement->get();
          $rows                            = $formeaGroupedElement->getLayout();
          $inputGroupItem['class']         = $formeaGroupedElement->class;
          $inputGroupItem['settings']      = $formeaGroupedElement->settings;
          $inputGroupItem['labelSettings'] = $formeaGroupedElement->labelSettings;
          $__elements                      = $formeaGroupedElement->getElementGridItem();
          $__elements                      = array_values($__elements);
          $inputGroupElements              = [];
          foreach ($__elements as $el) {
            $inputGroupElements[] = $el->content;
          }
          $inputGroupItem['elements']   = $inputGroupElements;
          $inputGroupItem['styleSheet'] = $formeaGroupedElement->styleSheet;
          $groupType                    = $formeaGroupedElement->group_type;
          /* $inputGroupItem         = [
          'class'         => '',
          'settings'      => '',
          'labelSettings' => '',
          'elements'      => [],
          'styleSheet'    => '',
          'igSetting'     => [
            'bare' => false
          ]
          ];*/
        }

        //borderStyleOptions
        $borderOptions      = FormeaGeneralHelper::getCssBorderStyles();
        $borderStyleOptions = [];
        $totalBorderOptions = count($borderOptions);
        for ($k = 0; $k < $totalBorderOptions; $k++) {
          $val = $borderOptions[$k];
          $txt = Text::_('COM_FORMEA_' . strtoupper($val));
          if ($val === 'none') {
            $val = '';
          }
          $borderStyleOptions[] = [
            'text' => $txt,
            'val' => $val,
            'selected' => false
          ];
        }

        $columnOptions = FormeaGeneralHelper::getFormLayoutColumnOptions();
        $gutterOptions = FormeaGeneralHelper::getGutterOptions();

        /**
         *
         * @var array $multiValSettingParams
         */
        $multiValSettingParams = FormeaGeneralHelper::getMultipleValueSettingParam();

        $stdColumnOption = [];
        for ($l = 1; $l < 13; $l++) {
          $stdColumnOption[] = [
            'text' => (string) $l,
            'val' => $l
          ];
        }

        $limitFilterOptions = [
          5,
          15,
          30,
          50,
        ];

        $groupTypeOptions = [
          ['text' => Text::_('COM_FORMEA_GRID'), 'val' => 0],
          ['text' => Text::_('COM_FORMEA_INPUT_GROUP'), 'val' => 1],
        ];
      }


      $ret = [
        'rows'                   => $rows,
        'inputGroupItem'         => $inputGroupItem,
        'groupType'              => $groupType,
        'groupTypeOptions'       => $groupTypeOptions,
        'elements'               => $elements,
        'langOptions'            => $langOptions,
        'layoutTextString'       => $layoutTextString,
        'elementTypes'           => $elementTypes,
        'batchColumnSetting'     => $batchColumnSetting,
        'defaultGeneralSettings' => $defaultGeneralSettings,
        'borderStyleOptions'     => $borderStyleOptions,
        'styleSheetParams'       => $styleSheetParams,
        'columnOptions'          => $columnOptions,
        'multiValSettingParams'  => $multiValSettingParams,
        'stdColumnOption'        => $stdColumnOption,
        'limitFilterOptions'     => $limitFilterOptions,
        'gutterOptions'          => $gutterOptions,
        'elementFilters'         => $elementFilters->toArray()
      ];
      $retObject->setSuccess(true);
      $retObject->setResult($ret);
    } catch (Exception $e) {
      $retObject->setMsg($e->getMessage());
    }

    if ($mode !== 'debug') {
      echo json_encode($retObject);
      $this->app->close();
    } else {
      return json_encode($retObject);
    }
  }


  public function getElementDetails()
  {
    $app               = Factory::getApplication();
    $element_id        = $app->getInput()->getInt('element_id', 0);
    $element_type_name = $app->getInput()->getString('type');
    $response          = new FsrResponse();
    if (empty($element_type_name)) {
      $response->setSuccess(false);
      $response->setMsg('Empty type', 'danger', true);
    } else {
      $config = [];
      if ($element_id > 0) {
        $config['element_id'] = $element_id;
      }
      $langData = FormeaGeneralHelper::prepareLangDataVerbose(true);

      $fmElement = new FormeaElement($config);
      $fmElement->set('type', $element_type_name);
      $element = $fmElement->getElement();

      $element->getDetails();
      $details = $element->details;

      $details_rearranged = [];
      foreach ($details as $lang_code => $detail) {
        if (isset($langData[$lang_code])) {
          $details_rearranged[] = (object) [
            'lang_code'  => $langData[$lang_code]['lang_code'],
            'lang_title' => $langData[$lang_code]['lang_title'],
            'detail'     => $detail
          ];
        }
      }
      $element->set('details', $details_rearranged);
      $element->details = $details_rearranged;
      $element->getValues();
      $values            = $element->elementvalues;
      $values_rearranged = [];
      foreach ($values as $lang_code => $detail) {
        if (isset($langData[$lang_code])) {
          $values_rearranged[] = (object) [
            'lang_code'  => $langData[$lang_code]['lang_code'],
            'lang_title' => $langData[$lang_code]['lang_title'],
            'detail'     => $detail
          ];
        }
      }
      $element->elementvalues = $values_rearranged;

      $element->getValidations();
      $element->getElementTypeConfig();
      $element->getAttributes();

      //validations
      $validations         = new FormeaValidations();
      $validationLists     = $validations->getLists();
      $selectedValidations = FormeaHelper::mapSelectedValidations($validationLists, $element->validations);


      $obj                      = new stdClass();
      $obj->id                  = $element->id;
      $obj->title               = $element->title;
      $obj->alias               = $element->alias;
      $obj->type                = $element->type;
      $obj->state               = $element->state;
      $obj->params              = $element->params;
      $obj->checked_out         = $element->checked_out;
      $obj->checked_out_time    = $element->checked_out_time;
      $obj->created_date        = $element->created_date;
      $obj->modified_date       = $element->modified_date;
      $obj->modified_by         = $element->modified_by;
      $obj->created_by          = $element->created_by;
      $obj->access_level        = $element->access_level;
      $obj->publish_up          = $element->publish_up;
      $obj->publish_down        = $element->publish_down;
      $obj->attributes          = $element->attributes;
      $obj->details             = $details_rearranged;
      $obj->elementvalues       = $values_rearranged;
      $obj->elementTypeConfig   = $element->elementTypeConfig;
      $obj->validations         = $element->validations;
      $obj->selectedValidations = $selectedValidations;

      //Access levels
      $ug = Access::assetgroups();


      $ret = [
        'element'          => $obj,
        'accessLevelLists' => $ug,
        'validationLists'  => $validations->getLists()
      ];
      // var_dump($ret);die;

      $response->setSuccess(true);
      $response->setResult($ret);
    }
    echo json_encode($response);
    $this->app->close();
  }

  public function getLayoutElementV2()
  {
    $response = new FsrResponse();
    try {
      $element_id = $this->app->getInput()->getInt('element_id', 0);
      $form_id    = $this->app->getInput()->getInt('form_id', 0);
      $gridId     = $this->app->getInput()->getInt('gridId', 0);
      $pageId     = $this->app->getInput()->getInt('pageId', 0);
      if ($element_id < 1) {
        throw new Exception('Invalid element');
      }
      $langTag = $this->app->getLanguage()->getTag();


      $formeaElement = new FormeaElement(['element_id' => $element_id]);
      $formeaElement->getElementTypeTitle();
      $formeaElement->getElementTypeId();
      $formeaElement->getElementTypeImage();
      $formeaElement->getLabelSettings();
      $element      = $formeaElement->getElement();
      $imageDetails = [
        'image'     => '',
        'imageSafe' => '',
        'imageType' => 0
      ];
      if (!empty($element->imageDetails) && isset($element->imageDetails['image'])) {
        if ($element->imageDetails['imageType'] === 1) {
          if (is_file(Path::clean(JPATH_ROOT . '/' . $element->imageDetails['image']))) {
            $imageDetails['image'] = file_get_contents(JPATH_ROOT . '/' . $element->imageDetails['image']);
          }
        } else {
          $imageDetails['image'] = Uri::base() . $element->imageDetails['image'];
        }
        $imageDetails['imageType'] = $element->imageDetails['imageType'];
      }
      $labelSettings = $element->labelSettings;

      $styleSheet = '';
      $settings   = FormeaGeneralHelper::getGeneralElementSettings();


      if ($form_id > 0) {
        $container = Factory::getContainer();
        /** @var DatabaseDriver $db */
        $db    = $container->get('DatabaseDriver');
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->quoteName('#__formea_form_elements'));
        $query->where($db->quoteName('form_id') . ' = ' . $db->quote($form_id));
        $query->where($db->quoteName('element_id') . ' = ' . $db->quote($element_id));
        $db->setQuery($query);
        $formElement = $db->loadObject();
        if (!empty($formElement)) {

          $formLabelSetting = json_decode($formElement->labelSettings);

          $totalLabelSetting = count($labelSettings);
          for ($i = 0; $i < $totalLabelSetting; $i++) {
            if (isset($formLabelSetting[$i]->helper_align)) {
              $labelSettings[$i]->helper_align = $formLabelSetting[$i]->helper_align;
            }
            if (isset($formLabelSetting[$i]->setting)) {
              $labelSettings[$i]->setting = $formLabelSetting[$i]->setting;
            }
          }

          $gridId = $formElement->id;

          $styleSheet = $formElement->styleSheet;
          $settings   = json_decode($formElement->settings);
          $pageId     = $formElement->page_id;
        }
      }

      $gridElement     = [
        'id'               => $gridId,
        'form_id'          => $form_id,
        'page_id'          => $pageId,
        'element_id'       => $element->id,
        'title'            => $element->title,
        'elementTypeTitle' => $element->elementTypeTitle,
        'type'             => $element->type,
        'labelSettings'    => $labelSettings,
        'settings'         => $settings,
        'styleSheet'       => $styleSheet,
        'state'            => $element->state,
        'alias'            => str_replace('-', '_', $element->alias)
      ];
      $elementGridItem = new FormeaGridItem([
        'id'         => $gridId,
        'item_type'  => 2,
        'active'     => false,
        'content'    => (object) $gridElement,
        'settings'   => $settings,
        'styleSheet' => $styleSheet,
      ], false);
      $ret             = [
        'elementGridItem' => $elementGridItem
      ];


      $response->setSuccess(true);
      $response->setResult($ret);
    } catch (Exception $e) {
      $response->setMsg($e->getMessage());
    }

    echo json_encode($response);
    $this->app->close();
  }
}
