<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

namespace Joomla\Component\Formea\Administrator\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\WebAsset\WebAssetManager;

class FormeaGroupedElementLayoutField extends FormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  1.7.0
	 */
	protected $type = 'FormeaGroupedElementLayout';

	public function __construct($form = null)
	{
		parent::__construct($form);
		$app = Factory::getApplication();
		/** @var WebAssetManager $wa */
		$wa = $app->getDocument()->getWebAssetManager();
		$wa->useScript('com_formea.admin-grouped-elements');
	}

	/**
	 * Method to get the field input markup for the file field.
	 * Field attributes allow specification of a maximum file size and a string
	 * of accepted file extensions.
	 *
	 * @return  string  The field input markup.
	 *
	 * @note    The field does not include an upload mechanism.
	 * @see     \Joomla\CMS\Form\Field\MediaField
	 * @since   1.7.0
	 */
	protected function getInput()
	{

		$loaderImage = Uri::root() . '/media/com_formea/img/loader.svg';
		$loaderText  = Text::_('COM_FORMEA_LOADING_LAYOUT_BUILDER');

		return '<grouped-elements loader-text="' . $loaderText . '" loader-img="' . $loaderImage . '" group-id="' . $this->value . '" form-name="' . $this->name . '"></grouped-elements>';
	}

	protected function getLabel()
	{
		return '';
	}
}
