<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Feseur\Library\FsrDate;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;
use Joomla\Component\Formea\Administrator\View\Dashboard\HtmlView;

/** @var HtmlView $this */
$links        = FormeaHelper::getFormeaMenus();
$totalLinks   = count($links);
$uri          = (string) Uri::getInstance();
$return       = urlencode(base64_encode($uri));
$formeaConfig = ComponentHelper::getParams('com_formea');
$dateFormat   = $formeaConfig->get('date_format', 'F j, Y h:i:a');
?>

<div class="row g-3">
   <div class="col-md-6">
      <div class="row g-3">
         <?php for ($i = 0; $i < $totalLinks; $i++) {
            $targetBlank = '';
            if (!$links[$i]->internal) {
               $targetBlank = 'target="_blank"';
            }
         ?>
            <div class="col-md-3 col-6">
               <a href="<?php echo $links[$i]->link; ?>"
                  <?php echo $targetBlank; ?> class="card px-2 card-clickable card-body h-100">
                  <div class="d-block text-center mb-2">
                     <i class="<?php echo $links[$i]->icon; ?> fa-2x"></i>
                  </div>
                  <div class="d-block text-center lh-1-2">
                     <?php echo $links[$i]->title; ?>
                  </div>
               </a>
            </div>
         <?php } ?>

      </div>
      <div class="card card-body mt-3">

         <h3 class="fw-light"><?php echo Text::_('COM_FORMEA_INSTALLED_FORMEA_PLUGINS'); ?></h3>
         <div class="block-lists">
            <?php
            $singular = [
               'eltypes'        => 'eltype',
               'validations'    => 'validation',
               'coreextensions' => 'coreextension',
               'core'           => 'coreextension',
               'themes'         => 'theme'
            ];
            foreach ($this->installedExtensions as $extension_type => $items) {
            ?>
               <div>
                  <p
                     class="fw-semibold mb-2"><?php echo Text::_('COM_FORMEA_EXTENSION_' . strtoupper($extension_type)); ?></p>
                  <?php if (!empty($items)) {
                     $splitItems      = array_chunk($items, ceil(count($items) / 3));
                     $totalSplitItems = count($splitItems);
                  ?>
                     <div class="row g-2">
                        <?php for ($j = 0; $j < $totalSplitItems; $j++) { ?>
                           <div class="col-md-4 col-6">
                              <?php $totalItems = count($splitItems[$j]);
                              for ($k = 0; $k < $totalItems; $k++) {
                                 $pluginLink = Route::_('index.php?option=com_formea&task=' . $singular[$extension_type] . '.edit&id=' . $splitItems[$j][$k]->id . '&return=' . $return);
                                 $class      = '';
                                 $icon       = 'fas fa-minus-circle';
                                 if ((int) $splitItems[$j][$k]->state > 0) {
                                    $class = 'active';
                                    $icon  = 'fas fa-check-circle';
                                 }
                              ?>
                                 <div class="technical-item <?php echo $class; ?>">
                                    <button>
                                       <i class="<?php echo $icon; ?>"></i>
                                    </button>
                                    <a class="info" href="<?php echo $pluginLink; ?>">
                                       <span class="text"><?php echo Text::_($splitItems[$j][$k]->title); ?></span>
                                       <span class="version">
                                          <?php echo $splitItems[$j][$k]->version; ?>
                                       </span>
                                    </a>
                                 </div>
                              <?php } ?>
                           </div>
                        <?php } ?>
                     </div>
                  <?php
                  } else { ?>
                     <div class="d-block bg-light rounded p-2 text-center text-muted small">
                        <?php echo Text::_('COM_FORMEA_NO_PLUGINS_INSTALLED'); ?>
                     </div>
                  <?php } ?>
               </div>
            <?php } ?>
         </div>
         <hr>
         <form action="<?php echo Route::_('index.php?option=com_formea'); ?>"
            method="post"
            class="d-block" enctype="multipart/form-data">
            <div class="row g-2 align-items-center">
               <div class="col-md-12">
                  <h5 class=" mb-0"><?php echo Text::_('COM_FORMEA_INSTALL_FORMEA_PLUGINS'); ?></h5>
               </div>
               <div class="col-md-6">
                  <div class="d-block">
                     <input class="form-control form-control-sm" type="file" id="plugin_package" name="plugin_package">
                  </div>
               </div>
               <div class="col-md-2">
                  <button class="btn btn-sm btn-primary"
                     type="submit"><?php echo Text::_('COM_FORMEA_INSTALL'); ?></button>
               </div>
            </div>
            <input type="hidden" name="task" value="dashboard.install">
            <?php echo HTMLHelper::_('form.token'); ?>
         </form>
      </div>
   </div>
   <div class="col-md-6">
      <div class="card card-body h-100">
         <?php if (empty($this->formIds)): ?>
            <div class="d-flex mb-2 flex-column bg-light justify-content-center align-items-center"
               style="height: 300px">
               <div><?php echo Text::_('COM_FORMEA_NO_FORM_NOTICE'); ?></div>
            </div>
         <?php endif; ?>
         <div class="d-block mb-2">
            <div id="formeaSubmissionChart"></div>
         </div>
         <!--Submissions-->
         <div class="d-block">
            <div class="d-flex align-items-center justify-content-between">
               <div>
                  <h3 class="fw-light"><?php echo Text::sprintf('COM_FORMEA_N_LATEST_SUBMISSIONS', 5); ?> </h3>
               </div>
               <div>
                  <a href="<?php echo Route::_('index.php?option=com_formea&view=submissions'); ?>"
                     class="btn btn-link btn-sm"><?php echo Text::_('COM_FORMEA_VIEW_ALL'); ?>
                     <?php echo (isset($this->submissions['totalItems'])) ? '(' . $this->submissions['totalItems'] . ')' : '' ?>
                  </a>
               </div>
            </div>
            <table class="table">
               <thead>
                  <tr>
                     <th class="fs-base"><?php echo Text::_('COM_FORMEA_FORM_NAME'); ?></th>
                     <th class="fs-base"><?php echo Text::_('COM_FORMEA_SUBMITTED_BY'); ?></th>
                     <th class="fs-base"><?php echo Text::_('JDATE'); ?></th>
                  </tr>
               </thead>
               <tbody>
                  <?php if (isset($this->submissions['submissionLists']) && !empty($this->submissions['submissionLists'])): ?>
                     <?php foreach ($this->submissions['submissionLists'] as $submission): ?>
                        <tr>
                           <td><a class="d-block"
                                 href="<?php echo Route::_('index.php?option=com_formea&task=submission.edit&id=' . $submission->id); ?>"><?php echo $submission->form_title; ?></a>
                           </td>
                           <td><?php echo (!empty($submission->user_name)) ? $submission->user_name : Text::_('COM_FORMEA_GUEST'); ?></td>
                           <td><?php echo (new FsrDate($submission->created_date))->format($dateFormat); ?></td>
                        </tr>
                     <?php endforeach; ?>
                  <?php else: ?>
                  <?php endif; ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>

</div>