<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\Component\Formea\Administrator\View\Elements\HtmlView;
use Joomla\Filesystem\Path;

HTMLHelper::_('bootstrap.tooltip', '.hasTooltip');
/** @var HtmlView $this */

$user      = Factory::getApplication()->getIdentity();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$saveOrder = $listOrder === 'a.ordering';

if ($saveOrder && !empty($this->items)) {
  $saveOrderingUrl = 'index.php?option=com_formea&task=elements.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
  HTMLHelper::_('draggablelist.draggable');
}

?>
<form action="<?php echo Route::_('index.php?option=com_formea&view=elements'); ?>" method="post" name="adminForm"
  id="adminForm">
  <div class="row">
    <div class="col-md-12">
      <div id="j-main-container" class="j-main-container">
        <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
        <?php if (empty($this->items)) : ?>
          <div class="alert alert-warning">
            <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
          </div>
        <?php else : ?>
          <table class="table itemList" id="formeaList">
            <caption class="visually-hidden">
              <?php echo Text::_('COM_FORMEA_TABLE_CAPTION'); ?>,
              <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
              <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
            </caption>
            <thead>
              <tr>
                <td class="w-1 text-center">
                  <?php echo HTMLHelper::_('grid.checkall'); ?>
                </td>
                <th scope="col" class="w-1 text-center">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" colspan="2" style="min-width:100px">
                  <?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_TABLE_TABLEHEAD_NAME', 'a.title', $listDirn, $listOrder); ?>
                </th>
                <th scope="col">
                  <?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_TABLE_TABLEHEAD_ALIAS', 'a.alias', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class=" d-none d-md-table-cell">
                  <?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_ELEMENT_TYPE', 'a.type', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-10 d-none d-md-table-cell">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ACCESS', 'access_level', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-3 d-none d-lg-table-cell">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
              </tr>
            </thead>
            <tbody>
              <?php
              foreach ($this->items as $i => $item) :
                $canEdit = $user->authorise('core.edit', 'com_formea.formea.' . $item->id);
                $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || is_null($item->checked_out);
                $canEditOwn = $user->authorise('core.edit.own', 'com_formea.formea.' . $item->id) && $item->created_by == $userId;
                $canChange = $user->authorise('core.edit.state', 'com_formea.formea.' . $item->id) && $canCheckin;
              ?>
                <tr class="row<?php echo $i % 2; ?>">
                  <td class="text-center">
                    <?php if ($item->element_type_enabled): ?>
                      <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                    <?php endif; ?>

                  </td>
                  <td class="text-center object-status align-middle">
                    <?php if ($item->element_type_enabled) {
                      echo HTMLHelper::_('jgrid.published', $item->state, $i, 'elements.', $canChange, 'cb', $item->publish_up, $item->publish_down);
                    } else { ?>
                      <div class="d-inline-block px-2 hasTooltip"
                        title="<?php echo Text::sprintf('COM_FORMEA_ELTYPE_S_DISABLED', $item->element_type_title); ?>">
                        <i class=" fas fa-exclamation-triangle icon-lg text-danger"></i>
                      </div>
                    <?php } ?>
                  </td>

                  <th scope="row"
                    class="has-context <?php echo (!$item->element_type_enabled) ? 'text-danger' : ''; ?>">
                    <?php if ($item->checked_out) : ?>
                      <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'elements.', true); ?>
                    <?php endif; ?>

                    <?php $editIcon = '<span class="fa fa-pencil-square me-2" aria-hidden="true"></span>'; ?>
                    <a class="<?php echo (!$item->element_type_enabled) ? 'text-danger' : ''; ?>"
                      href="<?php echo Route::_('index.php?option=com_formea&task=element.edit&type=' . $item->type . '&id=' . (int) $item->id); ?>">
                      <?php echo $editIcon; ?><?php echo $this->escape($item->title); ?></a>
                    <br><small><span
                        class="<?php echo (!$item->element_type_enabled) ? 'text-danger' : 'text-muted'; ?>"><?php echo Text::_('COM_FORMEA_CAPTION'); ?>:</span> <?php echo (!empty($item->caption)) ? $item->caption : '&mdash;'; ?>
                    </small>

                  </th>
                  <td class="align-middle">
                    <?php if (!$item->element_type_enabled) { ?>
                      <div class="text-danger fs-sm">
                        <?php echo Text::sprintf('COM_FORMEA_ELTYPE_S_DISABLED', $item->element_type_title); ?>
                      </div>
                    <?php } ?>
                  </td>
                  <td>
                    <?php echo $item->alias; ?>
                  </td>

                  <td class=" align-middle small d-none d-md-table-cell">
                    <div class="d-flex align-items-center">
                      <div class="icn icn-sm">
                        <?php
                        $typeClass = '';
                        if (!empty($item->imageDetails)) {
                          if ($item->imageDetails->imageType > 0) {
                            //svg
                            if (is_file(Path::clean(JPATH_ROOT . '/' . $item->imageDetails->image))) {
                              $svg = file_get_contents(JPATH_ROOT . '/' . $item->imageDetails->image);
                              echo $svg;
                              $typeClass = 'ms-2';
                            }
                          } else {
                        ?>
                            <img src="<?php echo $item->imageDetails->image; ?>">
                        <?php
                            $typeClass = 'ms-2';
                          }
                        } ?>
                      </div>
                      <div class="<?php echo $typeClass; ?>"><?php echo $item->type; ?></div>
                    </div>
                  </td>

                  <td class="align-middle small d-none d-md-table-cell">
                    <?php echo $item->access_level_title; ?>
                  </td>

                  <td class="align-middle d-none d-md-table-cell">
                    <?php echo $item->id; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>

          <?php echo $this->pagination->getListFooter(); ?>

          <?php echo HTMLHelper::_(
            'bootstrap.renderModal',
            'collapseModal',
            [
              'title'  => Text::sprintf('COM_FORMEA_BATCH_OPTIONS_S', strtolower(Text::_('COM_FORMEA_ELEMENTS'))),
              'footer' => $this->loadTemplate('batch_footer'),
            ],
            $this->loadTemplate('batch_body')
          ); ?>

          <?php echo HTMLHelper::_(
            'bootstrap.renderModal',
            'ElementSelectionModal',
            [
              'title'  => Text::_('COM_FORMEA_SELECT_ELEMENT'),
              'footer' => $this->loadTemplate('select_footer'),
            ],
            $this->loadTemplate('select_body')
          ); ?>

        <?php endif; ?>

        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
      </div>
    </div>
  </div>
</form>