<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
defined('_JEXEC') or die;

use Feseur\Library\FsrDate;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Formea\Administrator\View\Formeas\HtmlView;

/** @var HtmlView $this */

$user       = Factory::getApplication()->getIdentity();
$userId     = $user->get('id');
$listOrder  = $this->escape($this->state->get('list.ordering'));
$listDirn   = $this->escape($this->state->get('list.direction'));
$saveOrder  = $listOrder === 'a.ordering';
$dateFormat = $this->formeaConfig->get('date_format', 'Y-m-d H:i:s');
if ($saveOrder && !empty($this->items)) {
  $saveOrderingUrl = 'index.php?option=com_formea&task=formeas.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
  HTMLHelper::_('draggablelist.draggable');
}
$app = Factory::getApplication();
$session = $app->getSession();
$csrf    = $session->getFormToken();
?>
<form action="<?php echo Route::_('index.php?option=com_formea'); ?>" method="post" name="adminForm" id="adminForm">
  <div class="row">
    <div class="col-md-12">
      <div id="j-main-container" class="j-main-container">
        <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
        <?php if (empty($this->items)) : ?>
          <div class="alert alert-info">
            <span class="icon-info-circle" aria-hidden="true"></span><span
              class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
            <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
          </div>
        <?php else : ?>
          <table class="table itemList" id="formeaList">
            <caption class="visually-hidden">
              <?php echo Text::_('COM_FORMEA_TABLE_CAPTION'); ?>,
              <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
              <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
            </caption>
            <thead>
              <tr>
                <td class="w-1 text-center">
                  <?php echo HTMLHelper::_('grid.checkall'); ?>
                </td>

                <th scope="col" class="w-1 text-center">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" colspan="2" style="min-width:100px">
                  <?php echo HTMLHelper::_('searchtools.sort', 'COM_FORMEA_TABLE_TABLEHEAD_NAME', 'a.title', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-10 d-none d-md-table-cell">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ACCESS', 'access_level', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-3 d-none d-lg-table-cell text-center">
                  <?php echo Text::_('COM_FORMEA_SUBMISSION'); ?>
                </th>
                <th scope="col" class="w-20 d-none d-lg-table-cell">
                  <?php echo Text::_('JGLOBAL_FIELD_CREATED_LABEL'); ?>
                </th>
                <th scope="col" class="w-3 d-none d-lg-table-cell">
                  <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
              </tr>
            </thead>
            <tbody>
              <?php
              foreach ($this->items as $i => $item) :
                $canEdit = $user->authorise('core.edit', 'com_formea.formea.' . $item->id);
                $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || is_null($item->checked_out);
                $canEditOwn = $user->authorise('core.edit.own', 'com_formea.formea.' . $item->id) && $item->created_by == $userId;
                $canChange = $user->authorise('core.edit.state', 'com_formea.formea.' . $item->id) && $canCheckin;
                $frontEndLink = Uri::root() . 'index.php?option=com_formea&view=formea&id=' . $item->id . '&alias=' . $item->alias . '&tmpl=component&layout=modal';
              ?>
                <tr class="row<?php echo $i % 2; ?>">
                  <td class="text-center">
                    <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                  </td>
                  <td class="text-center object-status">
                    <?php echo HTMLHelper::_('jgrid.published', $item->state, $i, 'formeas.', $canChange, 'cb', $item->publish_up, $item->publish_down); ?>
                  </td>
                  <th scope="row" class="has-context">
                    <?php if ($item->checked_out) : ?>
                      <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'formeas.', true); ?>
                    <?php endif; ?>

                    <?php $editIcon = '<span class="fa fa-pencil-square me-2" aria-hidden="true"></span>'; ?>
                    <a class="hasTooltip"
                      href="<?php echo Route::_('index.php?option=com_formea&task=formea.edit&id=' . (int) $item->id); ?>"
                      title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape(
                                                                      (!empty($item->title)) ? addslashes($item->title) : $item->title
                                                                    ); ?>">
                      <?php echo $editIcon; ?><?php echo $this->escape($item->title); ?></a>
                    <br> <small><?php echo Text::_('JALIAS') ?> : <?php echo $item->alias; ?></small>
                  </th>
                  <td>
                    <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal"
                      data-bs-target="#modal-element_<?php echo $item->id ?>">
                      <?php echo Text::_('COM_FORMEA_FRONTEND_PREVIEW'); ?>
                    </button>

                    <?php
                    $title                      = Text::sprintf('COM_FORMEA_PREVIEW_S', $item->title);
                    $link                       = $frontEndLink;
                    $randomId                   = $title;
                    $modalParams['title']       = $this->escape($title);
                    $modalParams['footer']      = $this->loadTemplate('preview_footer');
                    $modalParams['url']         = $link;
                    $modalParams['backdrop']    = 'static';
                    $modalParams['keyboard']    = false;
                    $modalParams['closeButton'] = true;
                    $modalParams['height']      = '100%';
                    $modalParams['width']       = '100%';
                    $modalParams['bodyHeight']  = 70;
                    $modalParams['modalWidth']  = 80;
                    echo HTMLHelper::_('bootstrap.renderModal', 'modal-element_' . $item->id, $modalParams);
                    ?>
                  </td>
                  <td class="small d-none d-md-table-cell">
                    <?php echo $item->access_level_title; ?>
                  </td>

                  <td class="text-center">
                    <?php
                    $submissionLink = 'index.php?option=com_formea&view=submissions&filter[form_id]=' . $item->id;
                    ?>
                    <a href="<?php echo $submissionLink; ?>" class="badge bg-info"><?php echo $item->submissions; ?></a>
                    <?php if ($item->allow_submission < 1): ?>
                      <br>
                      <div class="d-block text-nowrap text-muted"><small>(<?php echo Text::_('COM_FORMEA_SUBMISSION_DISABLED'); ?>)</small></div>
                    <?php endif; ?>
                  </td>
                  <td>
                    <?php echo (new FsrDate($item->created_date))->format($dateFormat); ?>
                  </td>

                  <td class="d-none d-md-table-cell">
                    <?php echo $item->id; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>

          <?php echo $this->pagination->getListFooter(); ?>

          <?php echo HTMLHelper::_(
            'bootstrap.renderModal',
            'collapseModal',
            [
              'title'  => Text::sprintf('COM_FORMEA_BATCH_OPTIONS_S', strtolower(Text::_('COM_FORMEA_FORMEAS'))),
              'footer' => $this->loadTemplate('batch_footer'),
            ],
            $this->loadTemplate('batch_body')
          ); ?>

        <?php endif; ?>
        <input type="hidden" name="task" value="">
        <input type="hidden" name="boxchecked" value="0">
        <?php echo HTMLHelper::_('form.token'); ?>
      </div>
    </div>
  </div>
</form>
<formea-form-upload
  base-url="<?php echo Uri::base() ?>"
  csrf-token="<?php echo $csrf; ?>"></formea-form-upload>