<?php
  /**
   * @package         Joomla.Administrator
   * @subpackage      com_formea
   *
   * @copyright   (C) 2021 Open Source Matters, Inc. <https://www.joomla.org>
   * @license         GNU General Public License version 2 or later; see LICENSE.txt
   */

  defined('_JEXEC') or die;

  use Joomla\CMS\Factory;
  use Joomla\CMS\Layout\LayoutHelper;
  use Joomla\CMS\Uri\Uri;
  use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;

  $displayData = [
    'textPrefix' => 'COM_FORMEA_FORMEAS',
    'formURL'    => 'index.php?option=com_formea&view=formeas',
    'helpURL'    => FormeaHelper::getHelpLink('Formeas'),
    'icon'       => 'icon-formea-block',
  ];
  $app         = Factory::getApplication();
  $user        = $app->getIdentity();

  if ($user->authorise('core.create', 'com_formea') || count($user->getAuthorisedCategories('com_formea', 'core.create')) > 0)
  {
    $displayData['createURL'] = 'index.php?option=com_formea&task=formea.add';
  }

  $session = $app->getSession();
  $csrf    = $session->getFormToken();

  echo LayoutHelper::render('joomla.content.emptystate', $displayData);

?>
<formea-form-upload
  base-url="<?php echo Uri::base() ?>"
  csrf-token="<?php echo $csrf; ?>"
></formea-form-upload>
