<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_formea
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Formea\Administrator\Helper\FormeaHelper;

$displayData = [
	'textPrefix' => 'COM_FORMEA_GROUPED_ELEMENTS',
	'formURL'    => 'index.php?option=com_formea&view=groupedelements',
	'helpURL'    => FormeaHelper::getHelpLink('GroupedElements'),
	'icon'       => 'far fa-object-group',
];

$user = Factory::getApplication()->getIdentity();


if ($user->authorise('core.create', 'com_formea') || count($user->getAuthorisedCategories('com_formea', 'core.create')) > 0) {
	$displayData['createURL'] = 'index.php?option=com_formea&task=groupedelement.add';
}

echo LayoutHelper::render('joomla.content.emptystate', $displayData);
