<?php

/**
 * @package     Formea.Plugin
 * @subpackage  element
 *
 * @copyright   Copyright (C) 2010-2025 Feseur Sdn Bhd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @version     1.3.0
 */
// no direct access
defined('_JEXEC') or die();

use Joomla\Component\Formea\Site\Libraries\FormeaEltype;

class FormeaSelect extends FormeaEltype
{
  public function __construct($config = [])
  {
    parent::__construct($config);
  }

  public function getInput($class = [], $inputAttributes = [], $langTagUnderscore = '', $preview = false, $labelSetting = null)
  {

    $is_multi   = false;
    $themeClass = $this->getThemeClass();
    if (!empty($this->params)) {
      $is_multi = filter_var((int) $this->params->get('is_multi', '0'), FILTER_VALIDATE_BOOLEAN);
    }

    $submittedData = $this->getSubmittedElementData();
    $default_value = '';
    if (isset($inputAttributes['value'])) {
      $default_value = $inputAttributes['value'];
      unset($inputAttributes['value']);
    }
    if (!empty($submittedData->submitted_value)) {
      $default_value = $submittedData->submitted_value;
    }
    $error_msg = $submittedData->error_msg;
    $hasError  = $submittedData->hasError;
    $classAttr = [];
    if (!empty($submittedData->error_css_class)) {
      $classAttr[] = $submittedData->error_css_class;
    }

    $classAttr[] = $themeClass->getInputClass('select');
    if (!empty($class)) {
      $classAttr = array_merge($class, $classAttr);
    }


    $input = '<select class="' . implode(' ', $classAttr) . '" ';

    if (!$preview) {
      $input .= 'name="' . $this->formatElementName() . '" ';
    }

    if (isset($inputAttributes['placeholder'])) {
      $input .= 'placeholder="' . $inputAttributes['placeholder'] . '" ';
    }
    if ($is_multi) {
      $input .= ' multiple="true" ';
    }

    foreach ($inputAttributes as $attr => $attrVal) {
      if ($attr == 'size') {
        if (empty($attrVal)) {
          continue;
        }
        if ((int) $attrVal < 0) {
          continue;
        }
      }
      $input .= ' ' . $attr . '="' . $attrVal . '" ';
    }
    //$input .= 'value="' . $default_value . '" ';
    $input .= 'id="' . $this->formatElementId() . '" >';
    $input .= $this->getOptionLists($langTagUnderscore, $default_value);

    $input .= '</select>';


    return $input;
  }
}
